/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.extension.auth;

import java.util.Arrays;
import java.util.Collection;
import javax.servlet.Filter;
import org.apache.commons.configuration.Configuration;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.server.AbstractNeoServer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.ThirdPartyJaxRsPackage;
import org.neo4j.server.database.Database;
import org.neo4j.server.extension.auth.AuthenticationFilter;
import org.neo4j.server.extension.auth.MultipleAuthenticationService;
import org.neo4j.server.extension.auth.SingleUserAuthenticationService;
import org.neo4j.server.extension.auth.TypedInjectable;
import org.neo4j.server.plugins.Injectable;
import org.neo4j.server.plugins.SPIPluginLifecycle;
import org.neo4j.server.web.WebServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationExtensionInitializer
implements SPIPluginLifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationExtensionInitializer.class);
    private AuthenticationFilter adminAuthenticationFilter;
    private AuthenticationFilter authenticationFilter;
    private WebServer webServer;
    private String adminPath;

    public Collection<Injectable<?>> start(GraphDatabaseService graphDatabaseService, Configuration config) {
        throw new IllegalAccessError();
    }

    public void stop() {
        if (this.adminAuthenticationFilter != null) {
            this.webServer.removeFilter((Filter)this.adminAuthenticationFilter, this.adminPath);
        }
        if (this.authenticationFilter != null) {
            this.webServer.removeFilter((Filter)this.authenticationFilter, "/*");
        }
    }

    public Collection<Injectable<?>> start(NeoServer neoServer) {
        if (LOG.isInfoEnabled()) {
            LOG.info("START " + AuthenticationExtensionInitializer.class.toString());
        }
        this.webServer = this.getWebServer(neoServer);
        Configurator configurator = neoServer.getConfigurator();
        Configuration configuration = neoServer.getConfiguration();
        String masterCredendials = configuration.getString("org.neo4j.server.credentials");
        if (masterCredendials == null) {
            throw new RuntimeException("missing master-credentials in neo4j-server.properties");
        }
        SingleUserAuthenticationService adminAuth = new SingleUserAuthenticationService(masterCredendials);
        Database database = neoServer.getDatabase();
        GraphDatabaseAPI graphDatabaseAPI = database.getGraph();
        MultipleAuthenticationService users = new MultipleAuthenticationService(graphDatabaseAPI);
        this.adminAuthenticationFilter = new AuthenticationFilter("neo4j-admin", adminAuth);
        this.adminPath = this.getMyMountpoint(configurator) + "/*";
        this.webServer.addFilter((Filter)this.adminAuthenticationFilter, this.adminPath);
        this.authenticationFilter = new AuthenticationFilter("neo4j graphdb", users, adminAuth);
        this.webServer.addFilter((Filter)this.authenticationFilter, "/*");
        return Arrays.asList(TypedInjectable.injectable(users));
    }

    private WebServer getWebServer(NeoServer neoServer) {
        if (neoServer instanceof AbstractNeoServer) {
            return ((AbstractNeoServer)neoServer).getWebServer();
        }
        throw new IllegalArgumentException("expected AbstractNeoServer");
    }

    private String getMyMountpoint(Configurator configurator) {
        String packageName = this.getClass().getPackage().getName();
        for (ThirdPartyJaxRsPackage o : configurator.getThirdpartyJaxRsPackages()) {
            if (!o.getPackageName().equals(packageName)) continue;
            return o.getMountPoint();
        }
        throw new RuntimeException("unable to resolve our mountpoint?");
    }
}

