/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.extension.auth;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.neo4j.server.extension.auth.AuthenticationService;
import sun.misc.BASE64Decoder;

public class AuthenticationFilter
implements Filter {
    private final AuthenticationService[] authenticationService;
    private final String realmName;

    public AuthenticationFilter(String realmName, AuthenticationService ... authenticationService) {
        this.authenticationService = authenticationService;
        this.realmName = realmName;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        if (!(req instanceof HttpServletRequest) || !(res instanceof HttpServletResponse)) {
            throw new ServletException("request not allowed");
        }
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String header = request.getHeader("Authorization");
        if (this.checkAuth(((HttpServletRequest)req).getMethod(), header)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            this.sendAuthHeader(response);
        }
    }

    public void destroy() {
    }

    private boolean checkAuth(String method, String header) throws IOException {
        if (header == null) {
            return false;
        }
        String encoded = header.substring(header.indexOf(" ") + 1);
        byte[] credentials = new BASE64Decoder().decodeBuffer(encoded);
        for (AuthenticationService service : this.authenticationService) {
            if (!service.hasAccess(method, credentials)) continue;
            return true;
        }
        return false;
    }

    private void sendAuthHeader(HttpServletResponse response) throws IOException {
        response.setHeader("WWW-Authenticate", "Basic realm=\"" + this.realmName + "\"");
        response.sendError(401);
    }
}

