/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.extension.auth;

import java.io.IOException;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.map.ObjectMapper;
import org.neo4j.server.extension.auth.MultipleAuthenticationService;

@Path(value="/")
public class AuthenticationResource {
    private static final ObjectMapper mapper = new ObjectMapper();
    private final MultipleAuthenticationService users;

    public AuthenticationResource(@Context MultipleAuthenticationService users) {
        this.users = users;
    }

    @GET
    @Path(value="/list")
    public Response listUsers() throws IOException {
        String result = mapper.writeValueAsString(this.users.getUsers());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @POST
    @Path(value="/add-user-ro")
    public Response addUserRo(@FormParam(value="user") String user) {
        if (user == null) {
            throw new IllegalArgumentException("missing parameter 'user'");
        }
        this.users.setPermissionForUser(user, MultipleAuthenticationService.Permission.RO);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)"OK").build();
    }

    @POST
    @Path(value="/add-user-rw")
    public Response addUserRw(@FormParam(value="user") String user) {
        if (user == null) {
            throw new IllegalArgumentException("missing parameter 'user'");
        }
        this.users.setPermissionForUser(user, MultipleAuthenticationService.Permission.RW);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)"OK").build();
    }

    @POST
    @Path(value="/remove-user")
    public Response removeUser(@FormParam(value="user") String user) {
        if (user == null) {
            throw new IllegalArgumentException("missing parameter 'user'");
        }
        this.users.setPermissionForUser(user, MultipleAuthenticationService.Permission.NONE);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)"OK").build();
    }
}

