/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.extension.auth;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.server.extension.auth.AuthenticationService;

public class MultipleAuthenticationService
implements AuthenticationService {
    private static final String CONFIG_PREFIX = MultipleAuthenticationService.class.getPackage().getName();
    private static final Pattern USER_PATTERN = Pattern.compile(CONFIG_PREFIX + "\\.user\\.(.+?)(:.+)?");
    private final GraphDatabaseAPI graph;

    public MultipleAuthenticationService(GraphDatabaseAPI graph) {
        this.graph = graph;
    }

    @Override
    public boolean hasAccess(String method, byte[] credentials) {
        String cred = new String(credentials);
        String rights = this.getCredentials(cred);
        return this.isVerb(method, "PUT", "POST", "DELETE") && rights.contains("W") || this.isVerb(method, "GET") && rights.contains("R");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCredentials(String cred) {
        Transaction tx = this.graph.beginTx();
        try {
            PropertyContainer properties = this.getGraphProperties();
            String userKey = this.getUserKey(cred);
            Object result = properties.getProperty(userKey, (Object)"");
            String credentials = result instanceof Boolean ? "" : (String)result;
            tx.success();
            String string = credentials;
            return string;
        }
        finally {
            tx.finish();
        }
    }

    private PropertyContainer getGraphProperties() {
        NodeManager nodeManager = (NodeManager)this.graph.getDependencyResolver().resolveDependency(NodeManager.class);
        return nodeManager.getGraphProperties();
    }

    private String getUserKey(String cred) {
        return CONFIG_PREFIX + ".user." + cred;
    }

    public Map<String, Permission> getUsers() {
        try (Transaction tx = this.graph.beginTx();){
            HashMap<String, Permission> result = new HashMap<String, Permission>();
            PropertyContainer properties = this.getGraphProperties();
            for (String key : properties.getPropertyKeys()) {
                Matcher matcher = USER_PATTERN.matcher(key);
                if (!matcher.matches()) continue;
                String value = (String)properties.getProperty(key);
                result.put(matcher.group(1), Permission.valueOf(value));
            }
            tx.success();
            HashMap<String, Permission> hashMap = result;
            return hashMap;
        }
    }

    private boolean isVerb(String method, String ... verbs) {
        for (String verb : verbs) {
            if (!verb.equalsIgnoreCase(method)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPermissionForUser(String user, Permission permission) {
        Transaction transaction = this.graph.beginTx();
        try {
            PropertyContainer properties = this.getGraphProperties();
            String key = this.getUserKey(user);
            if (permission == Permission.NONE) {
                properties.removeProperty(key);
            } else {
                properties.setProperty(key, (Object)permission.name());
            }
            transaction.success();
        }
        catch (Exception e) {
            transaction.failure();
        }
        finally {
            transaction.finish();
        }
    }

    public static enum Permission {
        NONE,
        RO,
        RW;

    }
}

