/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.io.IOException;
import java.util.Iterator;
import java.util.function.Predicate;
import org.neo4j.consistency.checking.full.CloningRecordIterator;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.Scanner;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;

public class IterableStore<RECORD extends AbstractBaseRecord>
implements BoundedIterable<RECORD> {
    private final RecordStore<RECORD> store;
    private final boolean forward;
    private ResourceIterator<RECORD> iterator;

    public IterableStore(RecordStore<RECORD> store, boolean forward) {
        this.store = store;
        this.forward = forward;
    }

    public long maxCount() {
        return this.store.getHighId();
    }

    public void close() throws IOException {
        this.closeIterator();
    }

    private void closeIterator() {
        if (this.iterator != null) {
            this.iterator.close();
            this.iterator = null;
        }
    }

    public Iterator<RECORD> iterator() {
        this.closeIterator();
        ResourceIterable iterable = Scanner.scan(this.store, (boolean)this.forward, (Predicate[])new Predicate[0]);
        this.iterator = iterable.iterator();
        return CloningRecordIterator.cloned(this.iterator);
    }

    public void warmUpCache() {
        int recordsPerPage = this.store.getRecordsPerPage();
        long half = this.store.getHighId() / 2L;
        AbstractBaseRecord record = this.store.newRecord();
        for (long id = 0L; id < half; id += (long)(recordsPerPage - 1)) {
            this.store.getRecord(id, record, RecordLoad.FORCE);
        }
    }
}

