/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.statistics;

import org.neo4j.consistency.statistics.AccessStatistics;
import org.neo4j.consistency.statistics.Counts;
import org.neo4j.consistency.statistics.Statistics;
import org.neo4j.helpers.Format;
import org.neo4j.logging.Log;

public class VerboseStatistics
implements Statistics {
    private final AccessStatistics accessStatistics;
    private final Counts counts;
    private final Log logger;
    private long startTime;

    public VerboseStatistics(AccessStatistics accessStatistics, Counts counts, Log logger) {
        this.accessStatistics = accessStatistics;
        this.counts = counts;
        this.logger = logger;
    }

    @Override
    public void print(String name) {
        String accessStr = this.accessStatistics.getAccessStatSummary();
        this.logger.info(String.format("=== %s ===", name));
        this.logger.info(String.format("I/Os%n%s", accessStr));
        this.logger.info(this.counts.toString());
        this.logger.info(VerboseStatistics.memoryStats());
        this.logger.info("Done in  " + Format.duration((long)(System.currentTimeMillis() - this.startTime)));
    }

    @Override
    public void reset() {
        this.accessStatistics.reset();
        this.counts.reset();
        this.startTime = System.currentTimeMillis();
    }

    private static String memoryStats() {
        Runtime runtime = Runtime.getRuntime();
        return String.format("Memory[used:%s, free:%s, total:%s, max:%s]", Format.bytes((long)(runtime.totalMemory() - runtime.freeMemory())), Format.bytes((long)runtime.freeMemory()), Format.bytes((long)runtime.totalMemory()), Format.bytes((long)runtime.maxMemory()));
    }

    @Override
    public Counts getCounts() {
        return this.counts;
    }
}

