/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import io.netty.channel.Channel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.time.Clock;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bouncycastle.operator.OperatorCreationException;
import org.neo4j.bolt.security.ssl.Certificates;
import org.neo4j.bolt.security.ssl.KeyStoreFactory;
import org.neo4j.bolt.security.ssl.KeyStoreInformation;
import org.neo4j.bolt.transport.BoltProtocol;
import org.neo4j.bolt.transport.Netty4LogBridge;
import org.neo4j.bolt.transport.NettyServer;
import org.neo4j.bolt.transport.SocketTransport;
import org.neo4j.bolt.v1.runtime.MonitoredSessions;
import org.neo4j.bolt.v1.runtime.Sessions;
import org.neo4j.bolt.v1.runtime.internal.EncryptionRequiredSessions;
import org.neo4j.bolt.v1.runtime.internal.StandardSessions;
import org.neo4j.bolt.v1.runtime.internal.concurrent.ThreadedSessions;
import org.neo4j.bolt.v1.transport.BoltProtocolV1;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.Description;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.GroupSettingSupport;
import org.neo4j.kernel.configuration.Internal;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.udc.UsageData;

public class BoltKernelExtension
extends KernelExtensionFactory<Dependencies> {
    public BoltKernelExtension() {
        super("bolt-server");
    }

    public Lifecycle newInstance(KernelContext context, Dependencies dependencies) throws Throwable {
        Config config = dependencies.config();
        GraphDatabaseService gdb = dependencies.db();
        GraphDatabaseFacade api = (GraphDatabaseFacade)gdb;
        LogService logging = dependencies.logService();
        Log log = logging.getInternalLog(Sessions.class);
        LifeSupport life = new LifeSupport();
        JobScheduler scheduler = dependencies.scheduler();
        Netty4LogBridge.setLogProvider(logging.getInternalLogProvider());
        MonitoredSessions sessions = new MonitoredSessions(dependencies.monitors(), new ThreadedSessions((Sessions)life.add((Lifecycle)new StandardSessions(api, dependencies.usageData(), logging, dependencies.txBridge())), scheduler, logging), Clock.systemUTC());
        List<NettyServer.ProtocolInitializer> connectors = ((Stream)config.view(GroupSettingSupport.enumerate(GraphDatabaseSettings.Connector.class))).map(GraphDatabaseSettings.BoltConnector::new).filter(connConfig -> GraphDatabaseSettings.Connector.ConnectorType.BOLT.equals(config.get(connConfig.type)) && (Boolean)config.get(connConfig.enabled) != false).map(connConfig -> {
            SslContext sslCtx;
            HostnamePort address = (HostnamePort)config.get(connConfig.address);
            boolean requireEncryption = false;
            switch ((GraphDatabaseSettings.BoltConnector.EncryptionLevel)config.get(connConfig.encryption_level)) {
                case REQUIRED: {
                    requireEncryption = true;
                }
                case OPTIONAL: {
                    sslCtx = this.createSslContext(config, log, address);
                    break;
                }
                default: {
                    sslCtx = null;
                }
            }
            return new SocketTransport(address, sslCtx, logging.getInternalLogProvider(), this.newVersions(logging, requireEncryption ? new EncryptionRequiredSessions(sessions) : sessions));
        }).collect(Collectors.toList());
        if (connectors.size() > 0 && !((Boolean)config.get(GraphDatabaseSettings.disconnected)).booleanValue()) {
            life.add((Lifecycle)new NettyServer(scheduler.threadFactory(JobScheduler.Groups.boltNetworkIO), connectors));
            log.info("Bolt Server extension loaded.");
            for (NettyServer.ProtocolInitializer connector : connectors) {
                logging.getUserLog(Sessions.class).info("Bolt enabled on %s.", new Object[]{connector.address()});
            }
        }
        return life;
    }

    private SslContext createSslContext(Config config, Log log, HostnamePort address) {
        try {
            KeyStoreInformation keyStore = this.createKeyStore((Configuration)config, log, address);
            return SslContextBuilder.forServer((File)keyStore.getCertificatePath(), (File)keyStore.getPrivateKeyPath()).build();
        }
        catch (IOException | GeneralSecurityException | OperatorCreationException e) {
            throw new RuntimeException("Failed to initilize SSL encryption support, which is required to start this connector. Error was: " + e.getMessage(), e);
        }
    }

    private PrimitiveLongObjectMap<BiFunction<Channel, Boolean, BoltProtocol>> newVersions(LogService logging, Sessions sessions) {
        PrimitiveLongObjectMap availableVersions = Primitive.longObjectMap();
        availableVersions.put(1L, (channel, isEncrypted) -> {
            String descriptor = String.format("\tclient%s\tserver%s", channel.remoteAddress(), channel.localAddress());
            return new BoltProtocolV1(logging, sessions.newSession(descriptor, (boolean)isEncrypted), (Channel)channel);
        });
        return availableVersions;
    }

    private KeyStoreInformation createKeyStore(Configuration config, Log log, HostnamePort address) throws GeneralSecurityException, IOException, OperatorCreationException {
        File privateKeyPath = ((File)config.get(Settings.tls_key_file)).getAbsoluteFile();
        File certificatePath = ((File)config.get(Settings.tls_certificate_file)).getAbsoluteFile();
        if (!certificatePath.exists() && !privateKeyPath.exists()) {
            log.info("No SSL certificate found, generating a self-signed certificate..");
            Certificates certFactory = new Certificates();
            certFactory.createSelfSignedCertificate(certificatePath, privateKeyPath, address.getHost());
        }
        if (!certificatePath.exists()) {
            throw new IllegalStateException(String.format("TLS private key found, but missing certificate at '%s'. Cannot start server without certificate.", certificatePath));
        }
        if (!privateKeyPath.exists()) {
            throw new IllegalStateException(String.format("TLS certificate found, but missing key at '%s'. Cannot start server without key.", privateKeyPath));
        }
        return new KeyStoreFactory().createKeyStore(privateKeyPath, certificatePath);
    }

    public static interface Dependencies {
        public LogService logService();

        public Config config();

        public GraphDatabaseService db();

        public JobScheduler scheduler();

        public UsageData usageData();

        public Monitors monitors();

        public ThreadToStatementContextBridge txBridge();
    }

    public static class Settings {
        @Description(value="Directory for storing certificates to be used by Neo4j for TLS connections")
        public static Setting<File> certificates_directory = org.neo4j.kernel.configuration.Settings.pathSetting((String)"dbms.directories.certificates", (String)"certificates");
        @Internal
        @Description(value="Path to the X.509 public certificate to be used by Neo4j for TLS connections")
        public static Setting<File> tls_certificate_file = org.neo4j.kernel.configuration.Settings.derivedSetting((String)"unsupported.dbms.security.tls_certificate_file", certificates_directory, certificates -> new File((File)certificates, "neo4j.cert"), (Function)org.neo4j.kernel.configuration.Settings.PATH);
        @Internal
        @Description(value="Path to the X.509 private key to be used by Neo4j for TLS connections")
        public static final Setting<File> tls_key_file = org.neo4j.kernel.configuration.Settings.derivedSetting((String)"unsupported.dbms.security.tls_key_file", certificates_directory, certificates -> new File((File)certificates, "neo4j.key"), (Function)org.neo4j.kernel.configuration.Settings.PATH);
    }
}

