/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.security.auth;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.util.HexPrinter;
import org.neo4j.string.UTF8;

public abstract class AuthUtils {
    public static String uniqueIdentifier(StoreId storeId) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(UTF8.encode((String)storeId.toString()));
            byte[] digest = messageDigest.digest();
            ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream(digest.length);
            PrintStream stream = new PrintStream(byteArrayStream);
            new HexPrinter(stream).withByteSeparator("").withGroupSeparator("").append(digest);
            stream.flush();
            return byteArrayStream.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Hash algorithm is not available on this platform: " + e.getMessage(), e);
        }
    }
}

