/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.security.auth;

import java.io.IOException;
import java.util.Map;
import java.util.function.Supplier;
import org.neo4j.bolt.security.auth.Authentication;
import org.neo4j.bolt.security.auth.AuthenticationException;
import org.neo4j.bolt.security.auth.AuthenticationResult;
import org.neo4j.bolt.security.auth.BasicAuthenticationResult;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.security.auth.AuthSubject;
import org.neo4j.server.security.auth.BasicAuthManager;
import org.neo4j.server.security.auth.exception.IllegalCredentialsException;

public class BasicAuthentication
implements Authentication {
    private final BasicAuthManager authManager;
    private static final String SCHEME = "basic";
    private final Log log;
    private final Supplier<String> identifier;
    private AuthSubject authSubject;

    public BasicAuthentication(BasicAuthManager authManager, LogProvider logProvider, Supplier<String> identifier) {
        this.authManager = authManager;
        this.log = logProvider.getLog(this.getClass());
        this.identifier = identifier;
    }

    @Override
    public AuthenticationResult authenticate(Map<String, Object> authToken) throws AuthenticationException {
        if (!SCHEME.equals(authToken.get("scheme"))) {
            throw new AuthenticationException((Status)Status.Security.Unauthorized, this.identifier.get(), "Authentication token must contain: 'scheme : basic'");
        }
        String user = this.safeCast("principal", authToken);
        String password = this.safeCast("credentials", authToken);
        if (authToken.containsKey("new_credentials")) {
            return this.update(user, password, this.safeCast("new_credentials", authToken));
        }
        return this.authenticate(user, password);
    }

    private AuthenticationResult authenticate(String user, String password) throws AuthenticationException {
        this.authSubject = this.authManager.login(user, password);
        boolean credentialsExpired = false;
        switch (this.authSubject.getAuthenticationResult()) {
            case SUCCESS: {
                break;
            }
            case PASSWORD_CHANGE_REQUIRED: {
                credentialsExpired = true;
                break;
            }
            case TOO_MANY_ATTEMPTS: {
                throw new AuthenticationException((Status)Status.Security.AuthenticationRateLimit, this.identifier.get());
            }
            default: {
                this.log.warn("Failed authentication attempt for '%s'", new Object[]{user});
                throw new AuthenticationException((Status)Status.Security.Unauthorized, this.identifier.get());
            }
        }
        return new BasicAuthenticationResult((AccessMode)this.authSubject, credentialsExpired);
    }

    private AuthenticationResult update(String user, String password, String newPassword) throws AuthenticationException {
        this.authSubject = this.authManager.login(user, password);
        switch (this.authSubject.getAuthenticationResult()) {
            case SUCCESS: 
            case PASSWORD_CHANGE_REQUIRED: {
                try {
                    this.authSubject.setPassword(newPassword);
                    this.authSubject = this.authManager.login(user, newPassword);
                    break;
                }
                catch (AuthorizationViolationException e) {
                    throw new AuthenticationException((Status)Status.Security.Forbidden, this.identifier.get(), e.getMessage(), e);
                }
                catch (IOException e) {
                    throw new AuthenticationException((Status)Status.Security.Unauthorized, this.identifier.get(), e.getMessage(), e);
                }
                catch (IllegalCredentialsException e) {
                    throw new AuthenticationException(e.status(), this.identifier.get(), e.getMessage(), e);
                }
            }
            default: {
                throw new AuthenticationException((Status)Status.Security.Unauthorized, this.identifier.get());
            }
        }
        return new BasicAuthenticationResult((AccessMode)this.authSubject, false);
    }

    private String safeCast(String key, Map<String, Object> authToken) throws AuthenticationException {
        Object value = authToken.get(key);
        if (value == null || !(value instanceof String)) {
            throw new AuthenticationException((Status)Status.Security.Unauthorized, this.identifier.get(), "The value associated with the key `" + key + "` must be a String but was: " + (value == null ? "null" : value.getClass().getSimpleName()));
        }
        return (String)value;
    }
}

