/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.function.BiFunction;
import org.neo4j.bolt.transport.BoltProtocol;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class SocketTransportHandler
extends ChannelInboundHandlerAdapter {
    private final ProtocolChooser protocolChooser;
    private final Log log;
    private BoltProtocol protocol;

    public SocketTransportHandler(ProtocolChooser protocolChooser, LogProvider logging) {
        this.protocolChooser = protocolChooser;
        this.log = logging.getLog(((Object)((Object)this)).getClass());
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ByteBuf) {
            ByteBuf buffer = (ByteBuf)msg;
            if (this.protocol == null) {
                this.chooseProtocolVersion(ctx, buffer);
            } else {
                this.protocol.handle(ctx, buffer);
            }
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.close();
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.close();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.log.error("Fatal error occurred when handling a client connection: " + cause.getMessage(), cause);
        this.close();
    }

    private void close() {
        if (this.protocol != null) {
            this.protocol.close();
            this.protocol = null;
        }
    }

    private void chooseProtocolVersion(ChannelHandlerContext ctx, ByteBuf buffer) throws Exception {
        switch (this.protocolChooser.handleVersionHandshakeChunk(buffer, ctx.channel())) {
            case PROTOCOL_CHOSEN: {
                this.protocol = this.protocolChooser.chosenProtocol();
                ctx.writeAndFlush((Object)ctx.alloc().buffer(4).writeInt(this.protocol.version()));
                if (buffer.readableBytes() > 0) {
                    this.channelRead(ctx, buffer);
                } else {
                    buffer.release();
                }
                return;
            }
            case NO_APPLICABLE_PROTOCOL: {
                buffer.release();
                ctx.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])new byte[]{0, 0, 0, 0})).sync().channel().close();
                return;
            }
            case INVALID_HANDSHAKE: {
                buffer.release();
                ctx.close();
                return;
            }
        }
    }

    public static class ProtocolChooser {
        private final PrimitiveLongObjectMap<BiFunction<Channel, Boolean, BoltProtocol>> availableVersions;
        private final boolean isEncrypted;
        private final ByteBuffer handShake = ByteBuffer.allocateDirect(20).order(ByteOrder.BIG_ENDIAN);
        public static final int BOLT_MAGIC_PREAMBLE = 1616949271;
        private BoltProtocol protocol;

        public ProtocolChooser(PrimitiveLongObjectMap<BiFunction<Channel, Boolean, BoltProtocol>> availableVersions, boolean isEncrypted) {
            this.availableVersions = availableVersions;
            this.isEncrypted = isEncrypted;
        }

        public HandshakeOutcome handleVersionHandshakeChunk(ByteBuf buffer, Channel ch) {
            if (this.handShake.remaining() > buffer.readableBytes()) {
                this.handShake.limit(this.handShake.position() + buffer.readableBytes());
                buffer.readBytes(this.handShake);
                this.handShake.limit(this.handShake.capacity());
            } else {
                buffer.readBytes(this.handShake);
            }
            if (this.handShake.remaining() == 0) {
                this.handShake.flip();
                if (this.handShake.getInt() != 1616949271) {
                    return HandshakeOutcome.INVALID_HANDSHAKE;
                }
                for (int i = 0; i < 4; ++i) {
                    long suggestion = (long)this.handShake.getInt() & 0xFFFFFFFFL;
                    if (!this.availableVersions.containsKey(suggestion)) continue;
                    this.protocol = (BoltProtocol)((BiFunction)this.availableVersions.get(suggestion)).apply(ch, this.isEncrypted);
                    return HandshakeOutcome.PROTOCOL_CHOSEN;
                }
                return HandshakeOutcome.NO_APPLICABLE_PROTOCOL;
            }
            return HandshakeOutcome.PARTIAL_HANDSHAKE;
        }

        public BoltProtocol chosenProtocol() {
            return this.protocol;
        }
    }

    public static enum HandshakeOutcome {
        PROTOCOL_CHOSEN,
        PARTIAL_HANDSHAKE,
        INVALID_HANDSHAKE,
        NO_APPLICABLE_PROTOCOL;

    }
}

