/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import java.util.Map;
import org.neo4j.bolt.v1.runtime.spi.Record;
import org.neo4j.kernel.api.exceptions.Status;

public interface MessageHandler<E extends Exception> {
    public void handleRunMessage(String var1, Map<String, Object> var2) throws E;

    public void handlePullAllMessage() throws E;

    public void handleDiscardAllMessage() throws E;

    public void handleRecordMessage(Record var1) throws E;

    public void handleSuccessMessage(Map<String, Object> var1) throws E;

    public void handleFailureMessage(Status var1, String var2) throws E;

    public void handleIgnoredMessage() throws E;

    public void handleInitMessage(String var1, Map<String, Object> var2) throws E;

    public void handleResetMessage() throws E;

    public void handleAckFailureMessage() throws E;

    public static class Adapter<E extends Exception>
    implements MessageHandler<E> {
        @Override
        public void handleRunMessage(String statement, Map<String, Object> params) throws E {
        }

        @Override
        public void handlePullAllMessage() throws E {
        }

        @Override
        public void handleDiscardAllMessage() throws E {
        }

        @Override
        public void handleRecordMessage(Record item) throws E {
        }

        @Override
        public void handleSuccessMessage(Map<String, Object> metadata) throws E {
        }

        @Override
        public void handleFailureMessage(Status status, String message) throws E {
        }

        @Override
        public void handleIgnoredMessage() throws E {
        }

        @Override
        public void handleInitMessage(String clientName, Map<String, Object> credentials) throws E {
        }

        @Override
        public void handleResetMessage() throws E {
        }

        @Override
        public void handleAckFailureMessage() throws E {
        }
    }
}

