/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.bolt.v1.messaging.BoltIOException;
import org.neo4j.bolt.v1.messaging.PathPack;
import org.neo4j.bolt.v1.messaging.infrastructure.ValueNode;
import org.neo4j.bolt.v1.messaging.infrastructure.ValueRelationship;
import org.neo4j.bolt.v1.packstream.PackInput;
import org.neo4j.bolt.v1.packstream.PackOutput;
import org.neo4j.bolt.v1.packstream.PackStream;
import org.neo4j.bolt.v1.packstream.PackType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.api.exceptions.Status;

public class Neo4jPack {
    public static final List<Object> EMPTY_LIST = new ArrayList<Object>();
    public static final Map<String, Object> EMPTY_MAP = new HashMap<String, Object>();
    public static final byte NODE = 78;
    public static final byte RELATIONSHIP = 82;
    public static final byte UNBOUND_RELATIONSHIP = 114;
    public static final byte PATH = 80;

    public static class Unpacker
    extends PackStream.Unpacker {
        private PathPack.Unpacker pathUnpacker = new PathPack.Unpacker();

        public Unpacker(PackInput input) {
            super(input);
        }

        public Object unpack() throws IOException {
            PackType valType = this.peekNextType();
            switch (valType) {
                case STRING: {
                    return this.unpackString();
                }
                case INTEGER: {
                    return this.unpackLong();
                }
                case FLOAT: {
                    return this.unpackDouble();
                }
                case BOOLEAN: {
                    return this.unpackBoolean();
                }
                case NULL: {
                    this.unpackNull();
                    return null;
                }
                case LIST: {
                    return this.unpackList();
                }
                case MAP: {
                    return this.unpackMap();
                }
                case STRUCT: {
                    this.unpackStructHeader();
                    char signature = this.unpackStructSignature();
                    switch (signature) {
                        case 'N': {
                            throw new BoltIOException((Status)Status.Request.Invalid, "Nodes cannot be unpacked.");
                        }
                        case 'R': {
                            throw new BoltIOException((Status)Status.Request.Invalid, "Relationships cannot be unpacked.");
                        }
                        case 'r': {
                            throw new BoltIOException((Status)Status.Request.Invalid, "Relationships cannot be unpacked.");
                        }
                        case 'P': {
                            throw new BoltIOException((Status)Status.Request.Invalid, "Paths cannot be unpacked.");
                        }
                    }
                    throw new BoltIOException((Status)Status.Request.InvalidFormat, "Unknown struct type: " + Integer.toHexString(signature));
                }
                case END_OF_STREAM: {
                    this.unpackEndOfStream();
                    return null;
                }
            }
            throw new BoltIOException((Status)Status.Request.InvalidFormat, "Unknown value type: " + (Object)((Object)valType));
        }

        public List<Object> unpackList() throws IOException {
            ArrayList<Object> list;
            int size = (int)this.unpackListHeader();
            if (size == 0) {
                return EMPTY_LIST;
            }
            if ((long)size == -1L) {
                list = new ArrayList<Object>();
                boolean more = true;
                block3: while (more) {
                    PackType keyType = this.peekNextType();
                    switch (keyType) {
                        case END_OF_STREAM: {
                            this.unpack();
                            more = false;
                            continue block3;
                        }
                    }
                    list.add(this.unpack());
                }
            } else {
                list = new ArrayList(size);
                for (int i = 0; i < size; ++i) {
                    list.add(this.unpack());
                }
            }
            return list;
        }

        public Map<String, Object> unpackMap() throws IOException {
            HashMap<String, Object> map;
            int size = (int)this.unpackMapHeader();
            if (size == 0) {
                return EMPTY_MAP;
            }
            if ((long)size == -1L) {
                map = new HashMap<String, Object>();
                boolean more = true;
                block4: while (more) {
                    PackType keyType = this.peekNextType();
                    switch (keyType) {
                        case END_OF_STREAM: {
                            this.unpack();
                            more = false;
                            continue block4;
                        }
                        case STRING: {
                            Object val;
                            String key = this.unpackString();
                            if (map.put(key, val = this.unpack()) == null) continue block4;
                            throw new BoltIOException((Status)Status.Request.Invalid, "Duplicate map key `" + key + "`.");
                        }
                    }
                    throw new PackStream.PackStreamException("Bad key type");
                }
            } else {
                map = new HashMap(size, 1.0f);
                for (int i = 0; i < size; ++i) {
                    Object val;
                    String key = this.unpackString();
                    if (map.put(key, val = this.unpack()) == null) continue;
                    throw new BoltIOException((Status)Status.Request.Invalid, "Duplicate map key `" + key + "`.");
                }
            }
            return map;
        }
    }

    public static class Packer
    extends PackStream.Packer {
        private PathPack.Packer pathPacker = new PathPack.Packer();

        public Packer(PackOutput output) {
            super(output);
        }

        public void pack(Object obj) throws IOException {
            if (obj == null) {
                this.packNull();
            } else if (obj instanceof Boolean) {
                this.pack((Boolean)obj);
            } else if (obj instanceof Byte || obj instanceof Short || obj instanceof Integer || obj instanceof Long) {
                this.pack(((Number)obj).longValue());
            } else if (obj instanceof Float || obj instanceof Double) {
                this.pack(((Number)obj).doubleValue());
            } else if (obj instanceof String) {
                this.pack((String)obj);
            } else if (obj instanceof Map) {
                Map map = (Map)obj;
                this.packMapHeader(map.size());
                for (Map.Entry entry : map.entrySet()) {
                    this.pack(entry.getKey().toString());
                    this.pack(entry.getValue());
                }
            } else if (obj instanceof Collection) {
                Collection list = (Collection)obj;
                this.packListHeader(list.size());
                for (Object item : list) {
                    this.pack(item);
                }
            } else {
                if (obj instanceof byte[]) {
                    throw new UnsupportedOperationException("Binary values cannot be packed.");
                }
                if (obj instanceof short[]) {
                    short[] array = (short[])obj;
                    this.packListHeader(array.length);
                    for (short item : array) {
                        this.pack(item);
                    }
                } else if (obj instanceof int[]) {
                    int[] array = (int[])obj;
                    this.packListHeader(array.length);
                    for (int item : array) {
                        this.pack(item);
                    }
                } else if (obj instanceof long[]) {
                    long[] array = (long[])obj;
                    this.packListHeader(array.length);
                    for (long item : array) {
                        this.pack(item);
                    }
                } else if (obj instanceof float[]) {
                    float[] array = (float[])obj;
                    this.packListHeader(array.length);
                    for (float item : array) {
                        this.pack(item);
                    }
                } else if (obj instanceof double[]) {
                    double[] array = (double[])obj;
                    this.packListHeader(array.length);
                    for (double item : array) {
                        this.pack(item);
                    }
                } else if (obj instanceof boolean[]) {
                    boolean[] array = (boolean[])obj;
                    this.packListHeader(array.length);
                    for (boolean item : array) {
                        this.pack(item);
                    }
                } else if (obj.getClass().isArray()) {
                    Object[] array = (Object[])obj;
                    this.packListHeader(array.length);
                    for (Object item : array) {
                        this.pack(item);
                    }
                } else if (obj instanceof Node) {
                    ValueNode.pack(this, (Node)obj);
                } else if (obj instanceof Relationship) {
                    ValueRelationship.pack(this, (Relationship)obj);
                } else if (obj instanceof Path) {
                    this.pathPacker.pack(this, (Path)obj);
                } else {
                    throw new BoltIOException((Status)Status.General.UnknownError, "Unpackable value " + obj + " of type " + obj.getClass().getName());
                }
            }
        }

        public void packRawMap(Map<String, Object> map) throws IOException {
            this.packMapHeader(map.size());
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                this.pack(entry.getKey());
                this.pack(entry.getValue());
            }
        }
    }
}

