/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import java.io.IOException;
import java.util.Map;
import org.neo4j.bolt.v1.messaging.BoltIOException;
import org.neo4j.bolt.v1.messaging.MessageBoundaryHook;
import org.neo4j.bolt.v1.messaging.MessageFormat;
import org.neo4j.bolt.v1.messaging.MessageHandler;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.messaging.message.Message;
import org.neo4j.bolt.v1.packstream.PackStream;
import org.neo4j.bolt.v1.runtime.internal.Neo4jError;
import org.neo4j.bolt.v1.runtime.spi.Record;
import org.neo4j.bolt.v1.runtime.spi.Records;
import org.neo4j.kernel.api.exceptions.Status;

public class PackStreamMessageFormatV1
implements MessageFormat {
    public static final int VERSION = 1;

    @Override
    public int version() {
        return 1;
    }

    static String messageTypeName(int type) {
        switch (type) {
            case 1: {
                return "MSG_INIT";
            }
            case 14: {
                return "MSG_ACK_FAILURE";
            }
            case 15: {
                return "MSG_RESET";
            }
            case 16: {
                return "MSG_RUN";
            }
            case 47: {
                return "MSG_DISCARD_ALL";
            }
            case 63: {
                return "MSG_PULL_ALL";
            }
            case 113: {
                return "MSG_RECORD";
            }
            case 112: {
                return "MSG_SUCCESS";
            }
            case 126: {
                return "MSG_IGNORED";
            }
            case 127: {
                return "MSG_FAILURE";
            }
        }
        return "0x" + Integer.toHexString(type);
    }

    public static class Reader
    implements MessageFormat.Reader {
        private final Neo4jPack.Unpacker unpacker;

        public Reader(Neo4jPack.Unpacker unpacker) {
            this.unpacker = unpacker;
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.unpacker.hasNext();
        }

        @Override
        public <E extends Exception> void read(MessageHandler<E> output) throws IOException, E {
            try {
                this.unpacker.unpackStructHeader();
                int type = (int)this.unpacker.unpackLong();
                try {
                    switch (type) {
                        case 16: {
                            this.unpackRunMessage(output);
                            break;
                        }
                        case 47: {
                            this.unpackDiscardAllMessage(output);
                            break;
                        }
                        case 63: {
                            this.unpackPullAllMessage(output);
                            break;
                        }
                        case 113: {
                            this.unpackRecordMessage(output);
                            break;
                        }
                        case 112: {
                            this.unpackSuccessMessage(output);
                            break;
                        }
                        case 127: {
                            this.unpackFailureMessage(output);
                            break;
                        }
                        case 126: {
                            this.unpackIgnoredMessage(output);
                            break;
                        }
                        case 1: {
                            this.unpackInitMessage(output);
                            break;
                        }
                        case 15: {
                            output.handleResetMessage();
                            break;
                        }
                        case 14: {
                            output.handleAckFailureMessage();
                            break;
                        }
                        default: {
                            throw new BoltIOException((Status)Status.Request.Invalid, "0x" + Integer.toHexString(type) + " is not a valid message type.");
                        }
                    }
                }
                catch (PackStream.PackStreamException e) {
                    throw new BoltIOException((Status)Status.Request.InvalidFormat, "Unable to read " + PackStreamMessageFormatV1.messageTypeName(type) + " message. " + "Error was: " + e.getMessage(), e);
                }
            }
            catch (PackStream.PackStreamException e) {
                throw new BoltIOException((Status)Status.Request.InvalidFormat, "Unable to read message type. Error was: " + e.getMessage(), e);
            }
        }

        private <E extends Exception> void unpackSuccessMessage(MessageHandler<E> output) throws E, IOException {
            Map<String, Object> map = this.unpacker.unpackMap();
            output.handleSuccessMessage(map);
        }

        private <E extends Exception> void unpackFailureMessage(MessageHandler<E> output) throws E, IOException {
            Map<String, Object> map = this.unpacker.unpackMap();
            String codeStr = map.containsKey("code") ? (String)map.get("code") : Status.General.UnknownError.name();
            String msg = map.containsKey("message") ? (String)map.get("message") : "<No message supplied>";
            output.handleFailureMessage(Neo4jError.codeFromString(codeStr), msg);
        }

        private <E extends Exception> void unpackIgnoredMessage(MessageHandler<E> output) throws E {
            output.handleIgnoredMessage();
        }

        private <E extends Exception> void unpackRecordMessage(MessageHandler<E> output) throws E, IOException {
            long length = this.unpacker.unpackListHeader();
            Object[] fields = new Object[(int)length];
            int i = 0;
            while ((long)i < length) {
                fields[i] = this.unpacker.unpack();
                ++i;
            }
            output.handleRecordMessage(Records.record(fields));
        }

        private <E extends Exception> void unpackRunMessage(MessageHandler<E> output) throws E, IOException {
            String statement = this.unpacker.unpackString();
            Map<String, Object> params = this.unpacker.unpackMap();
            output.handleRunMessage(statement, params);
        }

        private <E extends Exception> void unpackDiscardAllMessage(MessageHandler<E> output) throws E, IOException {
            output.handleDiscardAllMessage();
        }

        private <E extends Exception> void unpackPullAllMessage(MessageHandler<E> output) throws E, IOException {
            output.handlePullAllMessage();
        }

        private <E extends Exception> void unpackInitMessage(MessageHandler<E> output) throws IOException, E {
            String clientName = this.unpacker.unpackString();
            Map<String, Object> credentials = this.unpacker.unpackMap();
            output.handleInitMessage(clientName, credentials);
        }
    }

    public static class Writer
    implements MessageFormat.Writer {
        public static final MessageBoundaryHook NO_OP = () -> {};
        private final Neo4jPack.Packer packer;
        private final MessageBoundaryHook onMessageComplete;

        public Writer(Neo4jPack.Packer packer, MessageBoundaryHook onMessageComplete) {
            this.packer = packer;
            this.onMessageComplete = onMessageComplete;
        }

        @Override
        public Writer write(Message message) throws IOException {
            message.dispatch(this);
            return this;
        }

        @Override
        public void handleRunMessage(String statement, Map<String, Object> params) throws IOException {
            this.packer.packStructHeader(2, (byte)16);
            this.packer.pack(statement);
            this.packer.packRawMap(params);
            this.onMessageComplete.onMessageComplete();
        }

        @Override
        public void handlePullAllMessage() throws IOException {
            this.packer.packStructHeader(0, (byte)63);
            this.onMessageComplete.onMessageComplete();
        }

        @Override
        public void handleDiscardAllMessage() throws IOException {
            this.packer.packStructHeader(0, (byte)47);
            this.onMessageComplete.onMessageComplete();
        }

        @Override
        public void handleRecordMessage(Record item) throws IOException {
            Object[] fields = item.fields();
            this.packer.packStructHeader(1, (byte)113);
            this.packer.packListHeader(fields.length);
            for (Object field : fields) {
                this.packer.pack(field);
            }
            this.onMessageComplete.onMessageComplete();
        }

        @Override
        public void handleSuccessMessage(Map<String, Object> metadata) throws IOException {
            this.packer.packStructHeader(1, (byte)112);
            this.packer.packRawMap(metadata);
            this.onMessageComplete.onMessageComplete();
        }

        @Override
        public void handleFailureMessage(Status status, String message) throws IOException {
            this.packer.packStructHeader(1, (byte)127);
            this.packer.packMapHeader(2);
            this.packer.pack("code");
            this.packer.pack(status.code().serialize());
            this.packer.pack("message");
            this.packer.pack(message);
            this.onMessageComplete.onMessageComplete();
        }

        @Override
        public void handleIgnoredMessage() throws IOException {
            this.packer.packStructHeader(0, (byte)126);
            this.onMessageComplete.onMessageComplete();
        }

        @Override
        public void handleInitMessage(String clientName, Map<String, Object> credentials) throws IOException {
            this.packer.packStructHeader(1, (byte)1);
            this.packer.pack(clientName);
            this.packer.packRawMap(credentials);
            this.onMessageComplete.onMessageComplete();
        }

        @Override
        public void handleResetMessage() throws IOException {
            this.packer.packStructHeader(0, (byte)15);
            this.onMessageComplete.onMessageComplete();
        }

        @Override
        public void handleAckFailureMessage() throws IOException {
            this.packer.packStructHeader(0, (byte)14);
            this.onMessageComplete.onMessageComplete();
        }

        @Override
        public void flush() throws IOException {
            this.packer.flush();
        }
    }

    public static interface MessageTypes {
        public static final byte MSG_INIT = 1;
        public static final byte MSG_ACK_FAILURE = 14;
        public static final byte MSG_RESET = 15;
        public static final byte MSG_RUN = 16;
        public static final byte MSG_DISCARD_ALL = 47;
        public static final byte MSG_PULL_ALL = 63;
        public static final byte MSG_RECORD = 113;
        public static final byte MSG_SUCCESS = 112;
        public static final byte MSG_IGNORED = 126;
        public static final byte MSG_FAILURE = 127;
    }
}

