/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging.infrastructure;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.neo4j.bolt.v1.messaging.infrastructure.UnboundRelationship;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;

public class ValuePath
implements Path {
    private final int length;
    private final List<Node> nodes;
    private final List<Relationship> relationships;
    private List<PropertyContainer> entities = null;

    public ValuePath(List<Node> nodes, List<Relationship> relationships, List<Integer> sequence) {
        int i;
        assert (nodes.size() >= 1);
        ArrayList<Integer> fullSequence = new ArrayList<Integer>(sequence);
        if (fullSequence.size() % 2 == 0) {
            fullSequence.add(0, 0);
        }
        int sequenceLength = fullSequence.size();
        this.length = sequenceLength / 2;
        this.nodes = new ArrayList<Node>(this.length + 1);
        for (i = 0; i < sequenceLength; i += 2) {
            int index = (Integer)fullSequence.get(i);
            this.nodes.add(nodes.get(index));
        }
        this.relationships = new ArrayList<Relationship>(this.length);
        for (i = 0; i < this.length; ++i) {
            Node endNode;
            Node startNode;
            Relationship relationship;
            int oneBasedIndex = (Integer)fullSequence.get(2 * i + 1);
            if (oneBasedIndex < 0) {
                relationship = relationships.get(-oneBasedIndex - 1);
                startNode = this.nodes.get(i + 1);
                endNode = this.nodes.get(i);
            } else {
                relationship = relationships.get(oneBasedIndex - 1);
                startNode = this.nodes.get(i);
                endNode = this.nodes.get(i + 1);
            }
            if (relationship instanceof UnboundRelationship) {
                UnboundRelationship unboundRel = (UnboundRelationship)relationship;
                relationship = unboundRel.bind(startNode, endNode);
            }
            this.relationships.add(relationship);
        }
    }

    public Node startNode() {
        return this.nodes.get(0);
    }

    public Node endNode() {
        return this.nodes.get(this.length);
    }

    public Relationship lastRelationship() {
        if (this.length == 0) {
            return null;
        }
        return this.relationships.get(this.length - 1);
    }

    public Iterable<Relationship> relationships() {
        return this.relationships;
    }

    public Iterable<Relationship> reverseRelationships() {
        throw new UnsupportedOperationException();
    }

    public Iterable<Node> nodes() {
        return this.nodes;
    }

    public Iterable<Node> reverseNodes() {
        throw new UnsupportedOperationException();
    }

    public int length() {
        return this.length;
    }

    public Iterator<PropertyContainer> iterator() {
        if (this.entities == null) {
            this.entities = new ArrayList<PropertyContainer>(2 * this.length + 1);
            for (int i = 0; i < this.length; ++i) {
                this.entities.add((PropertyContainer)this.nodes.get(i));
                this.entities.add((PropertyContainer)this.relationships.get(i));
            }
            this.entities.add((PropertyContainer)this.nodes.get(this.length));
        }
        return this.entities.iterator();
    }

    public String toString() {
        return "ValuePath{nodes=" + this.nodes + ", relationships=" + this.relationships + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValuePath that = (ValuePath)o;
        return this.nodes.equals(that.nodes) && this.relationships.equals(that.relationships);
    }

    public int hashCode() {
        int result = this.nodes.hashCode();
        result = 31 * result + this.relationships.hashCode();
        return result;
    }
}

