/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging.message;

import java.util.Collections;
import java.util.Map;
import org.neo4j.bolt.v1.messaging.message.DiscardAllMessage;
import org.neo4j.bolt.v1.messaging.message.InitMessage;
import org.neo4j.bolt.v1.messaging.message.Message;
import org.neo4j.bolt.v1.messaging.message.PullAllMessage;
import org.neo4j.bolt.v1.messaging.message.RecordMessage;
import org.neo4j.bolt.v1.messaging.message.ResetMessage;
import org.neo4j.bolt.v1.messaging.message.RunMessage;
import org.neo4j.bolt.v1.messaging.message.SuccessMessage;
import org.neo4j.bolt.v1.runtime.spi.Record;

public class Messages {
    private static final PullAllMessage PULL_ALL = new PullAllMessage();
    private static final DiscardAllMessage DISCARD_ALL = new DiscardAllMessage();
    private static final SuccessMessage SUCCESS = new SuccessMessage(Collections.EMPTY_MAP);

    public static Message reset() {
        return new ResetMessage();
    }

    public static Message run(String statement) {
        return new RunMessage(statement);
    }

    public static Message run(String statement, Map<String, Object> parameters) {
        return new RunMessage(statement, parameters);
    }

    public static Message init(String clientName, Map<String, Object> credentials) {
        return new InitMessage(clientName, credentials);
    }

    public static Message pullAll() {
        return PULL_ALL;
    }

    public static Message discardAll() {
        return DISCARD_ALL;
    }

    public static Message record(Record value) {
        return new RecordMessage(value);
    }

    public static Message success(Map<String, Object> metadata) {
        if (metadata.size() == 0) {
            return SUCCESS;
        }
        return new SuccessMessage(metadata);
    }
}

