/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging.message;

import java.util.Collections;
import java.util.Map;
import org.neo4j.bolt.v1.messaging.MessageHandler;
import org.neo4j.bolt.v1.messaging.message.Message;

public class RunMessage
implements Message {
    private final String statement;
    private final Map<String, Object> params;

    public RunMessage(String statement) {
        this(statement, Collections.EMPTY_MAP);
    }

    public RunMessage(String statement, Map<String, Object> params) {
        this.statement = statement;
        this.params = params;
    }

    public Map<String, Object> params() {
        return this.params;
    }

    public String statement() {
        return this.statement;
    }

    @Override
    public <E extends Exception> void dispatch(MessageHandler<E> consumer) throws E {
        consumer.handleRunMessage(this.statement, this.params);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunMessage that = (RunMessage)o;
        return this.params.equals(that.params) && this.statement.equals(that.statement);
    }

    public int hashCode() {
        int result = this.statement.hashCode();
        result = 31 * result + this.params.hashCode();
        return result;
    }

    public String toString() {
        return "RunMessage{statement='" + this.statement + '\'' + ", params=" + this.params + '}';
    }
}

