/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging.msgprocess;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.neo4j.bolt.v1.messaging.MessageHandler;
import org.neo4j.bolt.v1.runtime.Session;
import org.neo4j.bolt.v1.runtime.internal.Neo4jError;
import org.neo4j.logging.Log;

public class MessageProcessingCallback<T>
extends Session.Callback.Adapter<T, Void> {
    protected final Log log;
    protected MessageHandler<IOException> out;
    private Neo4jError error;
    private Runnable onCompleted;
    private boolean ignored;

    public static void publishError(MessageHandler<IOException> out, Neo4jError error) throws IOException {
        if (error.status().code().classification().refersToLog()) {
            out.handleFailureMessage(error.status(), String.format("An unexpected failure occurred, see details in the database logs, reference number %s.", error.reference()));
        } else {
            out.handleFailureMessage(error.status(), error.message());
        }
    }

    public MessageProcessingCallback(Log logger) {
        this.log = logger;
    }

    public MessageProcessingCallback reset(MessageHandler<IOException> out, Runnable onCompleted) {
        this.out = out;
        this.onCompleted = onCompleted;
        this.clearState();
        return this;
    }

    @Override
    public void failure(Neo4jError err, Void none) {
        this.error = err;
    }

    @Override
    public void ignored(Void none) {
        this.ignored = true;
    }

    @Override
    public void completed(Void none) {
        try {
            if (this.ignored) {
                this.out.handleIgnoredMessage();
            } else if (this.error != null) {
                MessageProcessingCallback.publishError(this.out, this.error);
            } else {
                this.out.handleSuccessMessage(this.successMetadata());
            }
        }
        catch (Throwable e) {
            this.log.error("Failed to write response to driver", e);
        }
        finally {
            this.onCompleted.run();
            this.clearState();
        }
    }

    protected Map<String, Object> successMetadata() {
        return Collections.emptyMap();
    }

    protected void clearState() {
        this.error = null;
        this.ignored = false;
    }
}

