/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging.msgprocess;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.bolt.v1.messaging.msgprocess.MessageProcessingCallback;
import org.neo4j.bolt.v1.runtime.spi.Record;
import org.neo4j.bolt.v1.runtime.spi.RecordStream;
import org.neo4j.logging.Log;

public class RecordStreamCallback
extends MessageProcessingCallback<RecordStream> {
    private final Map<String, Object> successMetadata = new HashMap<String, Object>();

    public RecordStreamCallback(Log log) {
        super(log);
    }

    @Override
    public void result(RecordStream stream, Void ignore) throws Exception {
        stream.accept(new RecordStream.Visitor(){

            @Override
            public void visit(Record record) throws IOException {
                RecordStreamCallback.this.out.handleRecordMessage(record);
            }

            @Override
            public void addMetadata(String key, Object value) {
                RecordStreamCallback.this.successMetadata.put(key, value);
            }
        });
    }

    @Override
    protected Map<String, Object> successMetadata() {
        return this.successMetadata;
    }

    @Override
    protected void clearState() {
        super.clearState();
        this.successMetadata.clear();
    }
}

