/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging.msgprocess;

import java.io.IOException;
import java.util.Map;
import org.neo4j.bolt.v1.messaging.MessageHandler;
import org.neo4j.bolt.v1.messaging.msgprocess.InitCallback;
import org.neo4j.bolt.v1.messaging.msgprocess.MessageProcessingCallback;
import org.neo4j.bolt.v1.messaging.msgprocess.RecordStreamCallback;
import org.neo4j.bolt.v1.messaging.msgprocess.RunCallback;
import org.neo4j.bolt.v1.runtime.Session;
import org.neo4j.bolt.v1.runtime.StatementMetadata;
import org.neo4j.bolt.v1.runtime.spi.RecordStream;
import org.neo4j.logging.Log;

public class TransportBridge
extends MessageHandler.Adapter<RuntimeException> {
    private final MessageProcessingCallback<Boolean> initCallback;
    private final MessageProcessingCallback<StatementMetadata> runCallback;
    private final MessageProcessingCallback<RecordStream> resultStreamCallback;
    private final MessageProcessingCallback<Void> simpleCallback;
    private Session session;

    public TransportBridge(Log log, Session session, MessageHandler<IOException> output, Runnable onEachCompletedRequest) {
        this.resultStreamCallback = new RecordStreamCallback(log);
        this.simpleCallback = new MessageProcessingCallback(log);
        this.runCallback = new RunCallback(log);
        this.initCallback = new InitCallback(log);
        this.session = session;
        this.initCallback.reset(output, onEachCompletedRequest);
        this.simpleCallback.reset(output, onEachCompletedRequest);
        this.resultStreamCallback.reset(output, onEachCompletedRequest);
        this.runCallback.reset(output, onEachCompletedRequest);
    }

    @Override
    public void handleInitMessage(String clientName, Map<String, Object> authToken) throws RuntimeException {
        this.session.init(clientName, authToken, null, this.initCallback);
    }

    @Override
    public void handleRunMessage(String statement, Map<String, Object> params) {
        this.session.run(statement, params, null, this.runCallback);
    }

    @Override
    public void handlePullAllMessage() {
        this.session.pullAll(null, this.resultStreamCallback);
    }

    @Override
    public void handleDiscardAllMessage() {
        this.session.discardAll(null, this.simpleCallback);
    }

    @Override
    public void handleResetMessage() throws RuntimeException {
        this.session.reset(null, this.simpleCallback);
    }

    @Override
    public void handleAckFailureMessage() throws RuntimeException {
        this.session.ackFailure(null, this.simpleCallback);
    }
}

