/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.packstream.utf8;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import org.neo4j.bolt.v1.packstream.utf8.UTF8Encoder;
import org.neo4j.bolt.v1.packstream.utf8.VanillaUTF8Encoder;
import org.neo4j.unsafe.impl.internal.dragons.FeatureToggles;

public class SunMiscUTF8Encoder
implements UTF8Encoder {
    private static final int BUFFER_SIZE = FeatureToggles.getInteger(SunMiscUTF8Encoder.class, (String)"buffer_size", (int)16384);
    private static final int fallbackAtStringLength = (int)((float)BUFFER_SIZE / StandardCharsets.UTF_8.newEncoder().averageBytesPerChar());
    private static final MethodHandle getCharArray = SunMiscUTF8Encoder.charArrayGetter();
    private static final MethodHandle arrayEncode = SunMiscUTF8Encoder.arrayEncode();
    private final CharsetEncoder charsetEncoder = StandardCharsets.UTF_8.newEncoder();
    private final byte[] out = new byte[BUFFER_SIZE];
    private final ByteBuffer outBuf = ByteBuffer.wrap(this.out);
    private final UTF8Encoder fallbackEncoder = new VanillaUTF8Encoder();

    @Override
    public ByteBuffer encode(String input) {
        try {
            if (input.length() > fallbackAtStringLength) {
                return this.fallbackEncoder.encode(input);
            }
            char[] rawChars = getCharArray.invoke(input);
            int len = arrayEncode.invoke(this.charsetEncoder, rawChars, 0, input.length(), this.out);
            if (len == -1) {
                return this.fallbackEncoder.encode(input);
            }
            this.outBuf.position(0);
            this.outBuf.limit(len);
            return this.outBuf;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return this.fallbackEncoder.encode(input);
        }
        catch (Throwable e) {
            throw new AssertionError("This encoder depends on sun.nio.cs.ArrayEncoder, which failed to load: " + e.getMessage(), e);
        }
    }

    private static MethodHandle arrayEncode() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            return lookup.unreflect(Class.forName("sun.nio.cs.ArrayEncoder").getMethod("encode", char[].class, Integer.TYPE, Integer.TYPE, byte[].class));
        }
        catch (Throwable e) {
            throw new AssertionError("This encoder depends on sun.nio.cs.ArrayEncoder, which failed to load: " + e.getMessage(), e);
        }
    }

    private static MethodHandle charArrayGetter() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            Field value = String.class.getDeclaredField("value");
            value.setAccessible(true);
            return lookup.unreflectGetter(value);
        }
        catch (Throwable e) {
            throw new AssertionError("This encoder depends being able to access raw char[] in java.lang.String, which failed: " + e.getMessage(), e);
        }
    }
}

