/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.time.Clock;
import java.util.Map;
import org.neo4j.bolt.v1.runtime.Session;
import org.neo4j.bolt.v1.runtime.Sessions;
import org.neo4j.bolt.v1.runtime.StatementMetadata;
import org.neo4j.bolt.v1.runtime.internal.Neo4jError;
import org.neo4j.bolt.v1.runtime.spi.RecordStream;
import org.neo4j.kernel.monitoring.Monitors;

public class MonitoredSessions
implements Sessions {
    private final SessionMonitor monitor;
    private final Sessions delegate;
    private final Clock clock;
    private final Monitors monitors;

    public MonitoredSessions(Monitors monitors, Sessions delegate, Clock clock) {
        this.delegate = delegate;
        this.clock = clock;
        this.monitors = monitors;
        this.monitor = (SessionMonitor)this.monitors.newMonitor(SessionMonitor.class, new String[0]);
    }

    @Override
    public Session newSession(String connectionDescriptor, boolean isEncrypted) {
        if (this.monitors.hasListeners(SessionMonitor.class)) {
            return new MonitoredSession(this.monitor, this.delegate.newSession(connectionDescriptor, isEncrypted), this.clock);
        }
        return this.delegate.newSession(connectionDescriptor, isEncrypted);
    }

    public static interface SessionMonitor {
        public void messageReceived();

        public void processingStarted(long var1);

        public void processingDone(long var1);
    }

    static class MonitoredSession
    implements Session {
        private final SessionMonitor monitor;
        private final Session delegate;
        private final Clock clock;

        public MonitoredSession(SessionMonitor monitor, Session delegate, Clock clock) {
            this.monitor = monitor;
            this.delegate = delegate;
            this.clock = clock;
        }

        @Override
        public String key() {
            return this.delegate.key();
        }

        @Override
        public String connectionDescriptor() {
            return this.delegate.connectionDescriptor();
        }

        @Override
        public <A> void init(String clientName, Map<String, Object> authToken, A attachment, Session.Callback<Boolean, A> callback) {
            this.monitor.messageReceived();
            this.delegate.init(clientName, authToken, attachment, this.withMonitor(callback));
        }

        @Override
        public <A> void run(String statement, Map<String, Object> params, A attachment, Session.Callback<StatementMetadata, A> callback) {
            this.monitor.messageReceived();
            this.delegate.run(statement, params, attachment, this.withMonitor(callback));
        }

        @Override
        public <A> void pullAll(A attachment, Session.Callback<RecordStream, A> callback) {
            this.monitor.messageReceived();
            this.delegate.pullAll(attachment, this.withMonitor(callback));
        }

        @Override
        public <A> void discardAll(A attachment, Session.Callback<Void, A> callback) {
            this.monitor.messageReceived();
            this.delegate.discardAll(attachment, this.withMonitor(callback));
        }

        @Override
        public <A> void reset(A attachment, Session.Callback<Void, A> callback) {
            this.monitor.messageReceived();
            this.delegate.reset(attachment, this.withMonitor(callback));
        }

        @Override
        public <A> void ackFailure(A attachment, Session.Callback<Void, A> callback) {
            this.monitor.messageReceived();
            this.delegate.ackFailure(attachment, this.withMonitor(callback));
        }

        @Override
        public void interrupt() {
            this.delegate.interrupt();
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        private <R, A> Session.Callback<R, A> withMonitor(final Session.Callback<R, A> callback) {
            return new Session.Callback<R, A>(){
                private final long start;
                private long queueTime;
                {
                    this.start = clock.millis();
                    this.queueTime = 0L;
                }

                @Override
                public void started(A attachment) {
                    this.queueTime = clock.millis() - this.start;
                    monitor.processingStarted(this.queueTime);
                    callback.started(attachment);
                }

                @Override
                public void result(R result, A attachment) throws Exception {
                    callback.result(result, attachment);
                }

                @Override
                public void failure(Neo4jError err, A attachment) {
                    callback.failure(err, attachment);
                    this.callMonitorDone();
                }

                @Override
                public void completed(A attachment) {
                    callback.completed(attachment);
                    this.callMonitorDone();
                }

                @Override
                public void ignored(A attachment) {
                    callback.ignored(attachment);
                    this.callMonitorDone();
                }

                private void callMonitorDone() {
                    monitor.processingDone(clock.millis() - this.start - this.queueTime);
                }
            };
        }
    }
}

