/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.util.Map;
import org.neo4j.bolt.v1.runtime.StatementMetadata;
import org.neo4j.bolt.v1.runtime.internal.Neo4jError;
import org.neo4j.bolt.v1.runtime.spi.RecordStream;

public interface Session
extends AutoCloseable {
    public String key();

    public String connectionDescriptor();

    public <A> void init(String var1, Map<String, Object> var2, A var3, Callback<Boolean, A> var4);

    public <A> void run(String var1, Map<String, Object> var2, A var3, Callback<StatementMetadata, A> var4);

    public <A> void pullAll(A var1, Callback<RecordStream, A> var2);

    public <A> void discardAll(A var1, Callback<Void, A> var2);

    public <A> void ackFailure(A var1, Callback<Void, A> var2);

    public <A> void reset(A var1, Callback<Void, A> var2);

    public void interrupt();

    @Override
    public void close();

    public static class Callbacks {
        private Callbacks() {
        }

        public static <V, A> Callback<V, A> noop() {
            return Callback.NO_OP;
        }
    }

    public static interface Callback<V, A> {
        public static final Callback NO_OP = new Adapter(){};

        public static <V, A> Callback<V, A> noOp() {
            return NO_OP;
        }

        public void started(A var1);

        public void result(V var1, A var2) throws Exception;

        public void failure(Neo4jError var1, A var2);

        public void completed(A var1);

        public void ignored(A var1);

        public static abstract class Adapter<V, A>
        implements Callback<V, A> {
            @Override
            public void started(A attachment) {
            }

            @Override
            public void result(V result, A attachment) throws Exception {
            }

            @Override
            public void failure(Neo4jError err, A attachment) {
            }

            @Override
            public void completed(A attachment) {
            }

            @Override
            public void ignored(A attachment) {
            }
        }
    }
}

