/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.bolt.v1.runtime.internal.ExecutionPlanConverter;
import org.neo4j.bolt.v1.runtime.spi.Record;
import org.neo4j.bolt.v1.runtime.spi.RecordStream;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.InputPosition;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.graphdb.Result;

public class CypherAdapterStream
implements RecordStream {
    private final Result delegate;
    private final String[] fieldNames;
    private CypherAdapterRecord currentRecord;

    public CypherAdapterStream(Result delegate) {
        this.delegate = delegate;
        this.fieldNames = delegate.columns().toArray(new String[delegate.columns().size()]);
        this.currentRecord = new CypherAdapterRecord(this.fieldNames);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public String[] fieldNames() {
        return this.fieldNames;
    }

    @Override
    public void accept(RecordStream.Visitor visitor) throws Exception {
        Iterable notifications;
        this.delegate.accept(row -> {
            visitor.visit(this.currentRecord.reset(row));
            return true;
        });
        QueryExecutionType qt = this.delegate.getQueryExecutionType();
        visitor.addMetadata("type", this.queryTypeCode(qt.queryType()));
        if (this.delegate.getQueryStatistics().containsUpdates()) {
            Map<String, Integer> stats = this.queryStats(this.delegate.getQueryStatistics());
            visitor.addMetadata("stats", stats);
        }
        if (qt.requestedExecutionPlanDescription()) {
            ExecutionPlanDescription rootPlanTreeNode = this.delegate.getExecutionPlanDescription();
            String metadataFieldName = rootPlanTreeNode.hasProfilerStatistics() ? "profile" : "plan";
            visitor.addMetadata(metadataFieldName, ExecutionPlanConverter.convert(rootPlanTreeNode));
        }
        if ((notifications = this.delegate.getNotifications()).iterator().hasNext()) {
            visitor.addMetadata("notifications", NotificationConverter.convert(notifications));
        }
    }

    private Map<String, Integer> queryStats(QueryStatistics queryStatistics) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        this.addIfNonZero(result, "nodes-created", queryStatistics.getNodesCreated());
        this.addIfNonZero(result, "nodes-deleted", queryStatistics.getNodesDeleted());
        this.addIfNonZero(result, "relationships-created", queryStatistics.getRelationshipsCreated());
        this.addIfNonZero(result, "relationships-deleted", queryStatistics.getRelationshipsDeleted());
        this.addIfNonZero(result, "properties-set", queryStatistics.getPropertiesSet());
        this.addIfNonZero(result, "labels-added", queryStatistics.getLabelsAdded());
        this.addIfNonZero(result, "labels-removed", queryStatistics.getLabelsRemoved());
        this.addIfNonZero(result, "indexes-added", queryStatistics.getIndexesAdded());
        this.addIfNonZero(result, "indexes-removed", queryStatistics.getIndexesRemoved());
        this.addIfNonZero(result, "constraints-added", queryStatistics.getConstraintsAdded());
        this.addIfNonZero(result, "constraints-removed", queryStatistics.getConstraintsRemoved());
        return result;
    }

    private void addIfNonZero(Map<String, Integer> map, String name, int count) {
        if (count > 0) {
            map.put(name, count);
        }
    }

    private String queryTypeCode(QueryExecutionType.QueryType queryType) {
        switch (queryType) {
            case READ_ONLY: {
                return "r";
            }
            case READ_WRITE: {
                return "rw";
            }
            case WRITE: {
                return "w";
            }
            case SCHEMA_WRITE: {
                return "s";
            }
        }
        return queryType.name();
    }

    private static class NotificationConverter {
        private NotificationConverter() {
        }

        public static Object convert(Iterable<Notification> notifications) {
            ArrayList out = new ArrayList();
            for (Notification notification : notifications) {
                HashMap<String, Object> notificationMap = new HashMap<String, Object>(4);
                notificationMap.put("code", notification.getCode());
                notificationMap.put("title", notification.getTitle());
                notificationMap.put("description", notification.getDescription());
                notificationMap.put("severity", notification.getSeverity().toString());
                InputPosition pos = notification.getPosition();
                if (!pos.equals((Object)InputPosition.empty)) {
                    HashMap<String, Integer> posMap = new HashMap<String, Integer>(3);
                    posMap.put("offset", pos.getOffset());
                    posMap.put("line", pos.getLine());
                    posMap.put("column", pos.getColumn());
                    notificationMap.put("position", posMap);
                }
                out.add(notificationMap);
            }
            return out;
        }
    }

    private static class CypherAdapterRecord
    implements Record {
        private final Object[] fields;
        private final String[] fieldNames;

        private CypherAdapterRecord(String[] fieldNames) {
            this.fields = new Object[fieldNames.length];
            this.fieldNames = fieldNames;
        }

        @Override
        public Object[] fields() {
            return this.fields;
        }

        public CypherAdapterRecord reset(Result.ResultRow cypherRecord) {
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i] = cypherRecord.get(this.fieldNames[i]);
            }
            return this;
        }
    }
}

