/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime.internal;

import java.util.Map;
import org.neo4j.bolt.v1.runtime.internal.CypherAdapterStream;
import org.neo4j.bolt.v1.runtime.internal.SessionState;
import org.neo4j.bolt.v1.runtime.spi.RecordStream;
import org.neo4j.bolt.v1.runtime.spi.StatementRunner;
import org.neo4j.graphdb.Result;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.QuerySession;

public class CypherStatementRunner
implements StatementRunner {
    private static final PropertyContainerLocker locker = new PropertyContainerLocker();
    private final QueryExecutionEngine queryExecutionEngine;

    public CypherStatementRunner(QueryExecutionEngine queryExecutionEngine) {
        this.queryExecutionEngine = queryExecutionEngine;
    }

    @Override
    public RecordStream run(SessionState ctx, String statement, Map<String, Object> params) throws KernelException {
        if (statement.equalsIgnoreCase("begin")) {
            ctx.beginTransaction();
            return RecordStream.EMPTY;
        }
        if (statement.equalsIgnoreCase("commit")) {
            ctx.commitTransaction();
            return RecordStream.EMPTY;
        }
        if (statement.equalsIgnoreCase("rollback")) {
            ctx.rollbackTransaction();
            return RecordStream.EMPTY;
        }
        boolean hasTx = ctx.hasTransaction();
        boolean isPeriodicCommit = this.queryExecutionEngine.isPeriodicCommit(statement);
        if (!hasTx && !isPeriodicCommit) {
            ctx.beginImplicitTransaction();
        }
        QuerySession session = ctx.createSession(this.queryExecutionEngine.queryService(), locker);
        Result result = this.queryExecutionEngine.executeQuery(statement, params, session);
        if (isPeriodicCommit) {
            ctx.beginImplicitTransaction();
        }
        return new CypherAdapterStream(result);
    }
}

