/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime.internal;

import org.neo4j.bolt.v1.runtime.Session;
import org.neo4j.bolt.v1.runtime.Sessions;
import org.neo4j.bolt.v1.runtime.internal.ErrorReportingSession;
import org.neo4j.bolt.v1.runtime.internal.Neo4jError;
import org.neo4j.kernel.api.exceptions.Status;

public class EncryptionRequiredSessions
implements Sessions {
    private final Sessions delegate;

    public EncryptionRequiredSessions(Sessions sessions) {
        this.delegate = sessions;
    }

    @Override
    public Session newSession(String connectionDescriptor, boolean isEncrypted) {
        if (!isEncrypted) {
            return new ErrorReportingSession(connectionDescriptor, new Neo4jError((Status)Status.Security.EncryptionRequired, "This server requires a TLS encrypted connection."));
        }
        return this.delegate.newSession(connectionDescriptor, isEncrypted);
    }
}

