/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime.internal;

import java.util.Map;
import java.util.UUID;
import org.neo4j.bolt.v1.runtime.Session;
import org.neo4j.bolt.v1.runtime.StatementMetadata;
import org.neo4j.bolt.v1.runtime.internal.Neo4jError;
import org.neo4j.bolt.v1.runtime.spi.RecordStream;

public class ErrorReportingSession
implements Session {
    private final String connectionDescriptor;
    private final Neo4jError error;
    private final String id;

    public ErrorReportingSession(String connectionDescriptor, Neo4jError error) {
        this.error = error;
        this.id = UUID.randomUUID().toString();
        this.connectionDescriptor = connectionDescriptor;
    }

    @Override
    public String key() {
        return this.id;
    }

    @Override
    public String connectionDescriptor() {
        return this.connectionDescriptor;
    }

    private <V, A> void reportError(A attachment, Session.Callback<V, A> callback) {
        if (callback != null) {
            callback.failure(this.error, attachment);
            callback.completed(attachment);
        }
    }

    @Override
    public <A> void init(String clientName, Map<String, Object> authToken, A attachment, Session.Callback<Boolean, A> callback) {
        this.reportError(attachment, callback);
    }

    @Override
    public <A> void run(String statement, Map<String, Object> params, A attachment, Session.Callback<StatementMetadata, A> callback) {
        this.reportError(attachment, callback);
    }

    @Override
    public <A> void pullAll(A attachment, Session.Callback<RecordStream, A> callback) {
        this.reportError(attachment, callback);
    }

    @Override
    public <A> void discardAll(A attachment, Session.Callback<Void, A> callback) {
        this.reportError(attachment, callback);
    }

    @Override
    public <A> void ackFailure(A attachment, Session.Callback<Void, A> callback) {
        this.reportError(attachment, callback);
    }

    @Override
    public <A> void reset(A attachment, Session.Callback<Void, A> callback) {
        this.reportError(attachment, callback);
    }

    @Override
    public void interrupt() {
    }

    @Override
    public void close() {
    }
}

