/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime.internal;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.bolt.security.auth.Authentication;
import org.neo4j.bolt.security.auth.AuthenticationException;
import org.neo4j.bolt.security.auth.AuthenticationResult;
import org.neo4j.bolt.v1.runtime.Session;
import org.neo4j.bolt.v1.runtime.StatementMetadata;
import org.neo4j.bolt.v1.runtime.internal.Neo4jError;
import org.neo4j.bolt.v1.runtime.internal.SessionState;
import org.neo4j.bolt.v1.runtime.internal.StandardStateMachineSPI;
import org.neo4j.bolt.v1.runtime.spi.RecordStream;
import org.neo4j.bolt.v1.runtime.spi.StatementRunner;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContext;
import org.neo4j.kernel.impl.query.QuerySession;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.udc.UsageData;

public class SessionStateMachine
implements Session,
SessionState {
    private final String id = UUID.randomUUID().toString();
    private final StatementMetadata currentStatementMetadata = new StatementMetadata(){

        @Override
        public String[] fieldNames() {
            return SessionStateMachine.this.currentResult.fieldNames();
        }
    };
    private final AtomicInteger interruptCounter = new AtomicInteger();
    private State state = State.UNINITIALIZED;
    private RecordStream currentResult;
    private KernelTransaction currentTransaction;
    private String currentQuerySource;
    private Session.Callback currentCallback;
    private Object currentAttachment;
    private AccessMode accessMode;
    private boolean credentialsExpired;
    private final SPI spi;

    public SessionStateMachine(String connectionDescriptor, UsageData usageData, GraphDatabaseFacade db, ThreadToStatementContextBridge txBridge, StatementRunner engine, LogService logging, Authentication authentication) {
        this(new StandardStateMachineSPI(connectionDescriptor, usageData, db, engine, logging, authentication, txBridge));
    }

    public SessionStateMachine(SPI spi) {
        this.spi = spi;
        this.accessMode = AccessMode.Static.NONE;
    }

    @Override
    public String key() {
        return this.id;
    }

    @Override
    public String connectionDescriptor() {
        return this.spi.connectionDescriptor();
    }

    private String querySource() {
        return this.currentQuerySource;
    }

    private void setQuerySourceFromClientNameAndPrincipal(String clientName, Object principal) {
        String principalName = principal == null ? "null" : principal.toString();
        this.currentQuerySource = String.format("bolt\t%s\t%s\t%s>", principalName, clientName, this.connectionDescriptor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void init(String clientName, Map<String, Object> authToken, A attachment, Session.Callback<Boolean, A> callback) {
        this.before(attachment, callback);
        try {
            this.state = this.state.init(this, clientName, authToken);
        }
        finally {
            this.after();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void run(String statement, Map<String, Object> params, A attachment, Session.Callback<StatementMetadata, A> callback) {
        this.before(attachment, callback);
        try {
            this.state = this.state.runStatement(this, statement, params);
        }
        finally {
            this.after();
        }
    }

    @Override
    public <A> void pullAll(A attachment, Session.Callback<RecordStream, A> callback) {
        this.before(attachment, callback);
        try {
            this.state = this.state.pullAll(this);
        }
        finally {
            this.after();
        }
    }

    @Override
    public <A> void discardAll(A attachment, Session.Callback<Void, A> callback) {
        this.before(attachment, callback);
        try {
            this.state = this.state.discardAll(this);
        }
        finally {
            this.after();
        }
    }

    @Override
    public <A> void ackFailure(A attachment, Session.Callback<Void, A> callback) {
        this.before(attachment, callback);
        try {
            this.state = this.state.ackFailure(this);
        }
        finally {
            this.after();
        }
    }

    @Override
    public <A> void reset(A attachment, Session.Callback<Void, A> callback) {
        this.before(attachment, callback);
        try {
            this.state = this.state.reset(this);
        }
        finally {
            this.after();
        }
    }

    @Override
    public void interrupt() {
        this.interruptCounter.incrementAndGet();
        KernelTransaction tx = this.currentTransaction;
        if (tx != null) {
            tx.markForTermination();
        }
    }

    @Override
    public void close() {
        this.before(null, null);
        try {
            this.state = this.state.halt(this);
        }
        finally {
            this.after();
        }
    }

    @Override
    public void beginImplicitTransaction() {
        this.state = this.state.beginImplicitTransaction(this);
    }

    @Override
    public void beginTransaction() {
        this.state = this.state.beginTransaction(this);
    }

    @Override
    public void commitTransaction() {
        this.state = this.state.commitTransaction(this);
    }

    @Override
    public void rollbackTransaction() {
        this.state = this.state.rollbackTransaction(this);
    }

    @Override
    public boolean hasTransaction() {
        return this.currentTransaction != null;
    }

    @Override
    public QuerySession createSession(GraphDatabaseQueryService service, PropertyContainerLocker locker) {
        InternalTransaction transaction = service.beginTransaction(KernelTransaction.Type.implicit, this.accessMode);
        Neo4jTransactionalContext transactionalContext = new Neo4jTransactionalContext(service, transaction, this.spi.currentStatement(), locker);
        return new BoltQuerySession(transactionalContext, this.querySource());
    }

    public State state() {
        return this.state;
    }

    public String toString() {
        return "Session[" + this.id + "," + this.state.name() + "]";
    }

    private void before(Object attachment, Session.Callback cb) {
        if (cb != null) {
            cb.started(attachment);
        }
        if (this.interruptCounter.get() > 0) {
            this.state = this.state.interrupt(this);
        }
        if (this.hasTransaction()) {
            this.spi.bindTransactionToCurrentThread(this.currentTransaction);
        }
        assert (this.currentCallback == null);
        assert (this.currentAttachment == null);
        this.currentCallback = cb;
        this.currentAttachment = attachment;
    }

    private void after() {
        block7: {
            try {
                if (this.currentCallback == null) break block7;
                try {
                    this.currentCallback.completed(this.currentAttachment);
                }
                finally {
                    this.currentCallback = null;
                    this.currentAttachment = null;
                }
            }
            finally {
                if (this.hasTransaction()) {
                    this.spi.unbindTransactionFromCurrentThread();
                }
            }
        }
    }

    private void error(Neo4jError err) {
        if (err.status().code().classification() == Status.Classification.DatabaseError) {
            this.spi.reportError(err);
        }
        if (this.currentCallback != null) {
            this.currentCallback.failure(err, this.currentAttachment);
        }
    }

    private void result(Object result) throws Exception {
        if (this.currentCallback != null) {
            this.currentCallback.result(result, this.currentAttachment);
        }
    }

    private void ignored() {
        if (this.currentCallback != null) {
            this.currentCallback.ignored(this.currentAttachment);
        }
    }

    private class BoltQuerySession
    extends QuerySession {
        private final String querySource;

        public BoltQuerySession(Neo4jTransactionalContext transactionalContext, String querySource) {
            super((TransactionalContext)transactionalContext);
            this.querySource = querySource;
        }

        public String toString() {
            return String.format("bolt-session\t%s", this.querySource);
        }
    }

    static interface SPI {
        public String connectionDescriptor();

        public void reportError(Neo4jError var1);

        public void reportError(String var1, Throwable var2);

        public KernelTransaction beginTransaction(KernelTransaction.Type var1, AccessMode var2);

        public void bindTransactionToCurrentThread(KernelTransaction var1);

        public void unbindTransactionFromCurrentThread();

        public RecordStream run(SessionStateMachine var1, String var2, Map<String, Object> var3) throws KernelException;

        public AuthenticationResult authenticate(Map<String, Object> var1) throws AuthenticationException;

        public void udcRegisterClient(String var1);

        public Statement currentStatement();
    }

    static enum State {
        UNINITIALIZED{

            @Override
            public State init(SessionStateMachine ctx, String clientName, Map<String, Object> authToken) {
                try {
                    AuthenticationResult authResult = ctx.spi.authenticate(authToken);
                    ctx.accessMode = authResult.getAccessMode();
                    ctx.credentialsExpired = authResult.credentialsExpired();
                    ctx.result(authResult.credentialsExpired());
                    ctx.spi.udcRegisterClient(clientName);
                    ctx.setQuerySourceFromClientNameAndPrincipal(clientName, authToken.get("principal"));
                    return IDLE;
                }
                catch (AuthenticationException e) {
                    return this.error(ctx, new Neo4jError(e.status(), e.getMessage(), e));
                }
                catch (Throwable e) {
                    return this.error(ctx, e);
                }
            }

            @Override
            protected State onNoImplementation(SessionStateMachine ctx, String command) {
                ctx.error(new Neo4jError((Status)Status.Request.Invalid, "No operations allowed until you send an INIT message."));
                return this.halt(ctx);
            }
        }
        ,
        IDLE{

            @Override
            public State beginTransaction(SessionStateMachine ctx) {
                assert (ctx.currentTransaction == null);
                ctx.currentTransaction = ctx.spi.beginTransaction(KernelTransaction.Type.explicit, ctx.accessMode);
                return IN_TRANSACTION;
            }

            @Override
            public State runStatement(SessionStateMachine ctx, String statement, Map<String, Object> params) {
                try {
                    ctx.currentResult = ctx.spi.run(ctx, statement, params);
                    ctx.result(ctx.currentStatementMetadata);
                    if (ctx.state == ERROR) {
                        return ERROR;
                    }
                    return STREAM_OPEN;
                }
                catch (Throwable e) {
                    return this.error(ctx, e);
                }
            }

            @Override
            public State beginImplicitTransaction(SessionStateMachine ctx) {
                assert (ctx.currentTransaction == null);
                ctx.currentTransaction = ctx.spi.beginTransaction(KernelTransaction.Type.implicit, ctx.accessMode);
                return IN_TRANSACTION;
            }

            @Override
            public State reset(SessionStateMachine ctx) {
                return IDLE;
            }

            @Override
            public State rollbackTransaction(SessionStateMachine ctx) {
                return this.error(ctx, new Neo4jError((Status)Status.Request.Invalid, "rollback cannot be done when there is no open transaction in the session."));
            }
        }
        ,
        IN_TRANSACTION{

            @Override
            public State runStatement(SessionStateMachine ctx, String statement, Map<String, Object> params) {
                return IDLE.runStatement(ctx, statement, params);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public State commitTransaction(SessionStateMachine ctx) {
                try {
                    KernelTransaction tx = ctx.currentTransaction;
                    ctx.currentTransaction = null;
                    tx.success();
                    tx.close();
                }
                catch (Throwable e) {
                    State state = this.error(ctx, e);
                    return state;
                }
                finally {
                    ctx.currentTransaction = null;
                }
                return IDLE;
            }

            @Override
            public State rollbackTransaction(SessionStateMachine ctx) {
                try {
                    KernelTransaction tx = ctx.currentTransaction;
                    ctx.currentTransaction = null;
                    tx.failure();
                    tx.close();
                    return IDLE;
                }
                catch (Throwable e) {
                    return this.error(ctx, e);
                }
            }

            @Override
            public State reset(SessionStateMachine ctx) {
                return this.rollbackTransaction(ctx);
            }
        }
        ,
        STREAM_OPEN{

            @Override
            public State pullAll(SessionStateMachine ctx) {
                try {
                    ctx.result(ctx.currentResult);
                    return this.discardAll(ctx);
                }
                catch (Throwable e) {
                    return this.error(ctx, e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public State discardAll(SessionStateMachine ctx) {
                try {
                    ctx.currentResult.close();
                    if (!ctx.hasTransaction()) {
                        State state = IDLE;
                        return state;
                    }
                    if (ctx.currentTransaction.transactionType() == KernelTransaction.Type.implicit) {
                        State state = IN_TRANSACTION.commitTransaction(ctx);
                        return state;
                    }
                    State state = IN_TRANSACTION;
                    return state;
                }
                catch (Throwable e) {
                    State state = this.error(ctx, e);
                    return state;
                }
                finally {
                    ctx.currentResult = null;
                }
            }

            @Override
            public State reset(SessionStateMachine ctx) {
                return this.discardAll(ctx).reset(ctx);
            }
        }
        ,
        ERROR{

            @Override
            public State reset(SessionStateMachine ctx) {
                return this.ackFailure(ctx).reset(ctx);
            }

            @Override
            public State ackFailure(SessionStateMachine ctx) {
                if (ctx.hasTransaction()) {
                    return IN_TRANSACTION;
                }
                return IDLE;
            }

            @Override
            protected State onNoImplementation(SessionStateMachine ctx, String command) {
                ctx.ignored();
                return ERROR;
            }
        }
        ,
        INTERRUPTED{

            @Override
            public State reset(SessionStateMachine ctx) {
                if (ctx.interruptCounter.get() > 0 && ctx.interruptCounter.decrementAndGet() > 0) {
                    ctx.ignored();
                    return INTERRUPTED;
                }
                return IDLE;
            }

            @Override
            public State interrupt(SessionStateMachine ctx) {
                return INTERRUPTED;
            }

            @Override
            protected State onNoImplementation(SessionStateMachine ctx, String command) {
                ctx.ignored();
                return INTERRUPTED;
            }
        }
        ,
        STOPPED{

            @Override
            public State halt(SessionStateMachine ctx) {
                return STOPPED;
            }

            @Override
            protected State onNoImplementation(SessionStateMachine ctx, String command) {
                ctx.ignored();
                return STOPPED;
            }
        };


        public State init(SessionStateMachine ctx, String clientName, Map<String, Object> authToken) {
            return this.onNoImplementation(ctx, "initializing the session");
        }

        public State runStatement(SessionStateMachine ctx, String statement, Map<String, Object> params) {
            return this.onNoImplementation(ctx, "running a statement");
        }

        public State pullAll(SessionStateMachine ctx) {
            return this.onNoImplementation(ctx, "pulling full stream");
        }

        public State discardAll(SessionStateMachine ctx) {
            return this.onNoImplementation(ctx, "discarding remainder of stream");
        }

        public State commitTransaction(SessionStateMachine ctx) {
            return this.onNoImplementation(ctx, "committing transaction");
        }

        public State rollbackTransaction(SessionStateMachine ctx) {
            return this.onNoImplementation(ctx, "rolling back transaction");
        }

        public State beginImplicitTransaction(SessionStateMachine ctx) {
            return this.onNoImplementation(ctx, "beginning implicit transaction");
        }

        public State beginTransaction(SessionStateMachine ctx) {
            return this.onNoImplementation(ctx, "beginning implicit transaction");
        }

        public State reset(SessionStateMachine ctx) {
            return this.onNoImplementation(ctx, "resetting the current session");
        }

        public State ackFailure(SessionStateMachine ctx) {
            return this.onNoImplementation(ctx, "acknowledging a failure");
        }

        public State interrupt(SessionStateMachine ctx) {
            this.reset(ctx);
            return INTERRUPTED;
        }

        protected State onNoImplementation(SessionStateMachine ctx, String command) {
            String msg = "'" + command + "' cannot be done when a session is in the '" + ctx.state.name() + "' state.";
            return this.error(ctx, new Neo4jError((Status)Status.Request.Invalid, msg));
        }

        public State halt(SessionStateMachine ctx) {
            if (ctx.currentTransaction != null) {
                try {
                    ctx.currentTransaction.close();
                }
                catch (Throwable e) {
                    ctx.error(Neo4jError.from(e));
                }
            }
            return STOPPED;
        }

        State error(SessionStateMachine ctx, Throwable err) {
            if (err instanceof AuthorizationViolationException && ctx.credentialsExpired) {
                return this.error(ctx, new Neo4jError((Status)Status.Security.CredentialsExpired, String.format("The credentials you provided were valid, but must be changed before you can use this instance. If this is the first time you are using Neo4j, this is to ensure you are not using the default credentials in production. If you are not using default credentials, you are getting this message because an administrator requires a password change.%nChanging your password is easy to do via the Neo4j Browser.%nIf you are connecting via a shell or programmatically via a driver, just issue a `CALL dbms.changePassword('new password')` statement in the current session, and then restart your driver with the new password configured.", new Object[0]), err));
            }
            return this.error(ctx, Neo4jError.from(err));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        State error(SessionStateMachine ctx, Neo4jError err) {
            ctx.spi.reportError(err);
            State outcome = ERROR;
            if (ctx.hasTransaction()) {
                switch (ctx.currentTransaction.transactionType()) {
                    case explicit: {
                        ctx.currentTransaction.failure();
                        break;
                    }
                    case implicit: {
                        try {
                            ctx.currentTransaction.failure();
                            ctx.currentTransaction.close();
                            break;
                        }
                        catch (Throwable t) {
                            ctx.spi.reportError("While handling '" + err.status() + "', a second failure occurred when " + "rolling back transaction: " + t.getMessage(), t);
                            break;
                        }
                        finally {
                            ctx.currentTransaction = null;
                        }
                    }
                }
            }
            ctx.error(err);
            return outcome;
        }
    }
}

