/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime.internal;

import java.util.function.Supplier;
import org.neo4j.bolt.security.auth.AuthUtils;
import org.neo4j.bolt.security.auth.Authentication;
import org.neo4j.bolt.security.auth.BasicAuthentication;
import org.neo4j.bolt.v1.runtime.Session;
import org.neo4j.bolt.v1.runtime.Sessions;
import org.neo4j.bolt.v1.runtime.internal.CypherStatementRunner;
import org.neo4j.bolt.v1.runtime.internal.SessionStateMachine;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.server.security.auth.BasicAuthManager;
import org.neo4j.udc.UsageData;

public class StandardSessions
extends LifecycleAdapter
implements Sessions {
    private final GraphDatabaseFacade gds;
    private final LifeSupport life = new LifeSupport();
    private final UsageData usageData;
    private final LogService logging;
    private final Authentication authentication;
    private CypherStatementRunner statementRunner;
    private ThreadToStatementContextBridge txBridge;

    public StandardSessions(GraphDatabaseFacade gds, UsageData usageData, LogService logging, ThreadToStatementContextBridge txBridge) {
        this.gds = gds;
        this.usageData = usageData;
        this.logging = logging;
        this.txBridge = txBridge;
        DependencyResolver dependencyResolver = gds.getDependencyResolver();
        this.txBridge = (ThreadToStatementContextBridge)dependencyResolver.resolveDependency(ThreadToStatementContextBridge.class);
        this.authentication = this.authentication(dependencyResolver);
    }

    public void init() throws Throwable {
        this.life.init();
    }

    public void start() throws Throwable {
        QueryExecutionEngine queryExecutionEngine = (QueryExecutionEngine)this.gds.getDependencyResolver().resolveDependency(QueryExecutionEngine.class);
        this.statementRunner = new CypherStatementRunner(queryExecutionEngine);
        this.life.start();
    }

    public void stop() throws Throwable {
        this.life.stop();
    }

    public void shutdown() throws Throwable {
        this.life.shutdown();
    }

    @Override
    public Session newSession(String connectionDescriptor, boolean isEncrypted) {
        return new SessionStateMachine(connectionDescriptor, this.usageData, this.gds, this.txBridge, this.statementRunner, this.logging, this.authentication);
    }

    private Authentication authentication(DependencyResolver dependencyResolver) {
        Config config = (Config)dependencyResolver.resolveDependency(Config.class);
        if (((Boolean)config.get(GraphDatabaseSettings.auth_enabled)).booleanValue()) {
            Supplier<String> identifier = () -> {
                StoreId storeId = ((NeoStoreDataSource)dependencyResolver.resolveDependency(NeoStoreDataSource.class)).getStoreId();
                return AuthUtils.uniqueIdentifier(storeId);
            };
            return new BasicAuthentication((BasicAuthManager)dependencyResolver.resolveDependency(BasicAuthManager.class), this.logging.getUserLogProvider(), identifier);
        }
        return Authentication.NONE;
    }
}

