/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime.internal;

import java.util.Map;
import org.neo4j.bolt.security.auth.Authentication;
import org.neo4j.bolt.security.auth.AuthenticationException;
import org.neo4j.bolt.security.auth.AuthenticationResult;
import org.neo4j.bolt.v1.runtime.internal.ErrorReporter;
import org.neo4j.bolt.v1.runtime.internal.Neo4jError;
import org.neo4j.bolt.v1.runtime.internal.SessionStateMachine;
import org.neo4j.bolt.v1.runtime.spi.RecordStream;
import org.neo4j.bolt.v1.runtime.spi.StatementRunner;
import org.neo4j.concurrent.DecayingFlags;
import org.neo4j.concurrent.RecentK;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.logging.Log;
import org.neo4j.udc.UsageData;
import org.neo4j.udc.UsageDataKeys;

class StandardStateMachineSPI
implements SessionStateMachine.SPI {
    private final String connectionDescriptor;
    private final UsageData usageData;
    private final GraphDatabaseFacade db;
    private final StatementRunner statementRunner;
    private final ErrorReporter errorReporter;
    private final Log log;
    private final Authentication authentication;
    private final ThreadToStatementContextBridge txBridge;
    private final DecayingFlags featureUsage;

    StandardStateMachineSPI(String connectionDescriptor, UsageData usageData, GraphDatabaseFacade db, StatementRunner statementRunner, LogService logging, Authentication authentication, ThreadToStatementContextBridge txBridge) {
        this.connectionDescriptor = connectionDescriptor;
        this.usageData = usageData;
        this.db = db;
        this.statementRunner = statementRunner;
        this.txBridge = txBridge;
        this.featureUsage = (DecayingFlags)usageData.get(UsageDataKeys.features);
        this.errorReporter = new ErrorReporter(logging);
        this.log = logging.getInternalLog(SessionStateMachine.class);
        this.authentication = authentication;
    }

    @Override
    public String connectionDescriptor() {
        return this.connectionDescriptor;
    }

    @Override
    public void reportError(Neo4jError err) {
        this.errorReporter.report(err);
    }

    @Override
    public void reportError(String message, Throwable cause) {
        this.log.error(message, cause);
    }

    @Override
    public KernelTransaction beginTransaction(KernelTransaction.Type type, AccessMode mode) {
        this.db.beginTransaction(type, mode);
        return this.txBridge.getKernelTransactionBoundToThisThread(false);
    }

    @Override
    public void bindTransactionToCurrentThread(KernelTransaction tx) {
        this.txBridge.bindTransactionToCurrentThread(tx);
    }

    @Override
    public void unbindTransactionFromCurrentThread() {
        this.txBridge.unbindTransactionFromCurrentThread();
    }

    @Override
    public RecordStream run(SessionStateMachine ctx, String statement, Map<String, Object> params) throws KernelException {
        this.featureUsage.flag(UsageDataKeys.Features.bolt);
        return this.statementRunner.run(ctx, statement, params);
    }

    @Override
    public AuthenticationResult authenticate(Map<String, Object> authToken) throws AuthenticationException {
        return this.authentication.authenticate(authToken);
    }

    @Override
    public void udcRegisterClient(String clientName) {
        ((RecentK)this.usageData.get(UsageDataKeys.clientNames)).add((Object)clientName);
    }

    @Override
    public Statement currentStatement() {
        return this.txBridge.get();
    }
}

