/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime.internal.concurrent;

import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.neo4j.bolt.v1.runtime.Session;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.logging.Log;

public class SessionWorker
implements Runnable {
    public static final Consumer<Session> SHUTDOWN = session1 -> {};
    private static final int workQueueSize = Integer.getInteger("org.neo4j.bolt.workQueueSize", 100);
    private final ArrayBlockingQueue<Consumer<Session>> workQueue = new ArrayBlockingQueue(workQueueSize);
    private final Session session;
    private final Log log;
    private final Log userLog;
    private boolean keepRunning;

    public SessionWorker(Session session, LogService logging) {
        this.session = session;
        this.log = logging.getInternalLog(this.getClass());
        this.userLog = logging.getUserLog(this.getClass());
    }

    public void handle(Consumer<Session> command) throws InterruptedException {
        this.workQueue.put(command);
    }

    @Override
    public void run() {
        this.keepRunning = true;
        ArrayList<Consumer<Session>> batch = new ArrayList<Consumer<Session>>(workQueueSize);
        try {
            while (this.keepRunning) {
                Consumer<Session> work = this.workQueue.poll(10L, TimeUnit.SECONDS);
                if (work == null) continue;
                this.execute(work);
                int items = this.workQueue.drainTo(batch);
                while (this.keepRunning && items > 0) {
                    this.executeBatch(batch);
                    items = this.workQueue.drainTo(batch);
                }
            }
        }
        catch (Throwable e) {
            this.log.error("Worker for session '" + this.session.key() + "' crashed: " + e.getMessage(), e);
            this.userLog.error("Fatal, worker for session '" + this.session.key() + "' crashed. Please" + " contact your support representative if you are unable to resolve this.", e);
            this.session.close();
        }
    }

    private void executeBatch(ArrayList<Consumer<Session>> batch) {
        for (int i = 0; this.keepRunning && i < batch.size(); ++i) {
            this.execute(batch.get(i));
        }
        batch.clear();
    }

    private void execute(Consumer<Session> work) {
        if (work == SHUTDOWN) {
            this.session.close();
            this.keepRunning = false;
        } else {
            work.accept(this.session);
        }
    }

    public void interrupt() {
        this.session.interrupt();
    }
}

