/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime.internal.concurrent;

import java.util.Map;
import java.util.function.Consumer;
import org.neo4j.bolt.v1.runtime.Session;
import org.neo4j.bolt.v1.runtime.StatementMetadata;
import org.neo4j.bolt.v1.runtime.internal.concurrent.SessionWorker;
import org.neo4j.bolt.v1.runtime.spi.RecordStream;

public class SessionWorkerFacade
implements Session {
    private final String key;
    private final String connectionDescriptor;
    private final SessionWorker worker;

    public SessionWorkerFacade(String key, String connectionDescriptor, SessionWorker worker) {
        this.key = key;
        this.connectionDescriptor = connectionDescriptor;
        this.worker = worker;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public String connectionDescriptor() {
        return this.connectionDescriptor;
    }

    @Override
    public <A> void init(String clientName, Map<String, Object> authToken, A attachment, Session.Callback<Boolean, A> callback) {
        this.queue(session -> session.init(clientName, authToken, attachment, callback));
    }

    @Override
    public <A> void run(String statement, Map<String, Object> params, A attachment, Session.Callback<StatementMetadata, A> callback) {
        this.queue(session -> session.run(statement, params, attachment, callback));
    }

    @Override
    public <A> void pullAll(A attachment, Session.Callback<RecordStream, A> callback) {
        this.queue(session -> session.pullAll(attachment, callback));
    }

    @Override
    public <A> void discardAll(A attachment, Session.Callback<Void, A> callback) {
        this.queue(session -> session.discardAll(attachment, callback));
    }

    @Override
    public <A> void reset(A attachment, Session.Callback<Void, A> callback) {
        this.worker.interrupt();
        this.queue(session -> session.reset(attachment, callback));
    }

    @Override
    public <A> void ackFailure(A attachment, Session.Callback<Void, A> callback) {
        this.queue(session -> session.ackFailure(attachment, callback));
    }

    @Override
    public void interrupt() {
        this.worker.interrupt();
    }

    @Override
    public void close() {
        this.queue(SessionWorker.SHUTDOWN);
    }

    private void queue(Consumer<Session> action) {
        try {
            this.worker.handle(action);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Worker interrupted while queueing request, the session may have been forcibly closed, or the database may be shutting down.");
        }
    }
}

