/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime.internal.concurrent;

import org.neo4j.bolt.v1.runtime.Session;
import org.neo4j.bolt.v1.runtime.Sessions;
import org.neo4j.bolt.v1.runtime.internal.concurrent.SessionWorker;
import org.neo4j.bolt.v1.runtime.internal.concurrent.SessionWorkerFacade;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.util.JobScheduler;

public class ThreadedSessions
implements Sessions {
    private Sessions delegate;
    private JobScheduler scheduler;
    private LogService logging;

    public ThreadedSessions(Sessions delegate, JobScheduler scheduler, LogService logging) {
        this.delegate = delegate;
        this.scheduler = scheduler;
        this.logging = logging;
    }

    @Override
    public Session newSession(String connectionDescriptor, boolean isEncrypted) {
        Session realSession = this.delegate.newSession(connectionDescriptor, isEncrypted);
        SessionWorker worker = new SessionWorker(realSession, this.logging);
        this.scheduler.schedule(JobScheduler.Groups.sessionWorker, (Runnable)worker, MapUtil.stringMap((String[])new String[]{"thread-id", realSession.key()}));
        return new SessionWorkerFacade(realSession.key(), realSession.connectionDescriptor(), worker);
    }
}

