/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.bolt.transport.BoltProtocol;
import org.neo4j.bolt.v1.messaging.MessageFormat;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.messaging.PackStreamMessageFormatV1;
import org.neo4j.bolt.v1.messaging.msgprocess.MessageProcessingCallback;
import org.neo4j.bolt.v1.messaging.msgprocess.TransportBridge;
import org.neo4j.bolt.v1.runtime.Session;
import org.neo4j.bolt.v1.runtime.internal.Neo4jError;
import org.neo4j.bolt.v1.transport.BoltV1Dechunker;
import org.neo4j.bolt.v1.transport.ChunkedOutput;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.logging.Log;

public class BoltProtocolV1
implements BoltProtocol {
    public static final int VERSION = 1;
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private final ChunkedOutput output;
    private final MessageFormat.Writer packer;
    private final BoltV1Dechunker dechunker;
    private final Session session;
    private final Log log;
    private final AtomicInteger inFlight = new AtomicInteger(0);

    public BoltProtocolV1(LogService logging, Session session, Channel channel) {
        this.log = logging.getInternalLog(this.getClass());
        this.session = session;
        this.output = new ChunkedOutput(channel, 8192);
        this.packer = new PackStreamMessageFormatV1.Writer(new Neo4jPack.Packer(this.output), this.output);
        this.dechunker = new BoltV1Dechunker(new TransportBridge(this.log, session, this.packer, this::onMessageDone), this::onMessageStarted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(ChannelHandlerContext channelContext, ByteBuf data) throws IOException {
        try {
            this.dechunker.handle(data);
        }
        catch (Throwable e) {
            this.handleUnexpectedError(channelContext, e);
        }
        finally {
            data.release();
        }
    }

    @Override
    public int version() {
        return 1;
    }

    @Override
    public synchronized void close() {
        this.dechunker.close();
        this.session.close();
        this.output.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUnexpectedError(ChannelHandlerContext channelContext, Throwable e) {
        block8: {
            try {
                try {
                    MessageProcessingCallback.publishError(this.packer, Neo4jError.from(e));
                    this.packer.flush();
                }
                catch (Throwable e1) {
                    try {
                        this.log.error(String.format("Session %s: Secondary error while notifying client of problem: %s", this.session.key(), e.getMessage()), e);
                        break block8;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        channelContext.close();
                    }
                }
                channelContext.close();
            }
            finally {
                this.close();
            }
        }
    }

    private void onMessageStarted() {
        this.inFlight.incrementAndGet();
    }

    private void onMessageDone() {
        if (this.inFlight.decrementAndGet() == 0 && !this.dechunker.isInMiddleOfAMessage()) {
            try {
                this.packer.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

