/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import org.neo4j.bolt.v1.messaging.MessageHandler;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.messaging.PackStreamMessageFormatV1;
import org.neo4j.bolt.v1.transport.ChunkedInput;

public class BoltV1Dechunker {
    private final ChunkedInput input;
    private final PackStreamMessageFormatV1.Reader unpacker;
    private final MessageHandler<RuntimeException> onMessage;
    private final Runnable onMessageStarted;
    private State state = State.AWAITING_CHUNK;
    private int chunkSize = 0;

    public BoltV1Dechunker(MessageHandler<RuntimeException> messageHandler, Runnable onMessageStarted) {
        this.onMessage = messageHandler;
        this.onMessageStarted = onMessageStarted;
        this.input = new ChunkedInput();
        this.unpacker = new PackStreamMessageFormatV1.Reader(new Neo4jPack.Unpacker(this.input));
    }

    public boolean isInMiddleOfAMessage() {
        return this.chunkSize != 0;
    }

    public void handle(ByteBuf data) throws IOException {
        while (data.readableBytes() > 0) {
            switch (this.state) {
                case AWAITING_CHUNK: {
                    if (data.readableBytes() >= 2) {
                        this.chunkSize = data.readUnsignedShort();
                        this.handleHeader();
                        break;
                    }
                    this.chunkSize = data.readUnsignedByte() << 8;
                    this.state = State.IN_HEADER;
                    break;
                }
                case IN_HEADER: {
                    this.chunkSize |= data.readUnsignedByte();
                    this.handleHeader();
                    break;
                }
                case IN_CHUNK: {
                    if (this.chunkSize < data.readableBytes()) {
                        this.input.append(data.readSlice(this.chunkSize));
                        this.state = State.AWAITING_CHUNK;
                        break;
                    }
                    if (this.chunkSize == data.readableBytes()) {
                        this.input.append(data);
                        this.state = State.AWAITING_CHUNK;
                        return;
                    }
                    this.chunkSize -= data.readableBytes();
                    this.input.append(data);
                    return;
                }
                case CLOSED: {
                    return;
                }
            }
        }
    }

    public synchronized void close() {
        this.state = State.CLOSED;
        this.input.close();
    }

    private void handleHeader() throws IOException {
        if (this.chunkSize == 0) {
            try {
                this.onMessageStarted.run();
                this.unpacker.read(this.onMessage);
            }
            finally {
                this.input.clear();
            }
            this.state = State.AWAITING_CHUNK;
        } else {
            this.state = State.IN_CHUNK;
        }
    }

    public static enum State {
        AWAITING_CHUNK,
        IN_CHUNK,
        IN_HEADER,
        CLOSED;

    }
}

