/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.bolt.v1.messaging.BoltIOException;
import org.neo4j.bolt.v1.packstream.PackInput;
import org.neo4j.kernel.api.exceptions.Status;

public class ChunkedInput
implements PackInput {
    private List<ByteBuf> chunks = new ArrayList<ByteBuf>();
    private ByteBuf currentChunk = null;
    private int currentChunkIndex = -1;
    private int remaining = 0;

    public ChunkedInput clear() {
        this.currentChunk = null;
        this.currentChunkIndex = -1;
        this.remaining = 0;
        for (int i = 0; i < this.chunks.size(); ++i) {
            this.chunks.get(i).release();
        }
        if (this.chunks.size() > 128) {
            this.chunks = new ArrayList<ByteBuf>();
        } else {
            this.chunks.clear();
        }
        return this;
    }

    public void append(ByteBuf chunk) {
        if (chunk.readableBytes() > 0) {
            this.chunks.add(chunk.retain());
            this.remaining += chunk.readableBytes();
        }
    }

    @Override
    public boolean hasMoreData() throws IOException {
        return this.remaining > 0;
    }

    @Override
    public byte peekByte() throws IOException {
        this.ensureChunkAvailable();
        return this.currentChunk.getByte(this.currentChunk.readerIndex());
    }

    @Override
    public byte readByte() throws IOException {
        this.ensure(1);
        --this.remaining;
        return this.currentChunk.readByte();
    }

    @Override
    public short readShort() throws IOException {
        this.ensure(2);
        if (this.currentChunk.readableBytes() >= 2) {
            this.remaining -= 2;
            return this.currentChunk.readShort();
        }
        short higher = (short)((short)this.readByte() << 8);
        short lower = (short)(0xFF & this.readByte());
        return (short)(higher | lower);
    }

    @Override
    public int readInt() throws IOException {
        this.ensure(4);
        if (this.currentChunk.readableBytes() >= 4) {
            this.remaining -= 4;
            return this.currentChunk.readInt();
        }
        int higher = this.readShort() << 16;
        int lower = 0xFFFF & this.readShort();
        return higher | lower;
    }

    @Override
    public long readLong() throws IOException {
        this.ensure(8);
        if (this.currentChunk.readableBytes() >= 8) {
            this.remaining -= 8;
            return this.currentChunk.readLong();
        }
        long higher = (long)this.readInt() << 32;
        long lower = 0xFFFFFFFFL & (long)this.readInt();
        return higher | lower;
    }

    @Override
    public double readDouble() throws IOException {
        this.ensure(8);
        if (this.currentChunk.readableBytes() >= 8) {
            this.remaining -= 8;
            return this.currentChunk.readDouble();
        }
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public PackInput readBytes(byte[] into, int offset, int toRead) throws IOException {
        this.ensureChunkAvailable();
        int toReadFromChunk = Math.min(toRead, this.currentChunk.readableBytes());
        this.currentChunk.readBytes(into, offset, toReadFromChunk);
        this.remaining -= toReadFromChunk;
        if (toReadFromChunk < toRead) {
            this.readBytes(into, offset + toReadFromChunk, toRead - toReadFromChunk);
        }
        return this;
    }

    private void ensure(int numBytes) throws IOException {
        this.ensureChunkAvailable();
        if (this.remaining < numBytes) {
            throw new BoltIOException((Status)Status.Request.InvalidFormat, "Unable to deserialize request, message boundary found before message ended. This indicates a serialization or framing problem with your client driver.");
        }
    }

    private void ensureChunkAvailable() throws IOException {
        while (this.currentChunk == null || this.currentChunk.readableBytes() == 0) {
            ++this.currentChunkIndex;
            if (this.currentChunkIndex < this.chunks.size()) {
                this.currentChunk = this.chunks.get(this.currentChunkIndex);
                continue;
            }
            throw new BoltIOException((Status)Status.Request.InvalidFormat, "Unable to deserialize request, message boundary found before message ended. This indicates a serialization or framing problem with your client driver.");
        }
    }

    public void close() {
        this.clear();
    }
}

