/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.bolt.v1.messaging.MessageBoundaryHook;
import org.neo4j.bolt.v1.packstream.PackOutput;

public class ChunkedOutput
implements PackOutput,
MessageBoundaryHook {
    public static final int CHUNK_HEADER_SIZE = 2;
    public static final int MESSAGE_BOUNDARY = 0;
    private final int bufferSize;
    private final int maxChunkSize;
    private ByteBuf buffer;
    private Channel channel;
    private int currentChunkHeaderOffset;
    private boolean chunkOpen = false;

    public ChunkedOutput(Channel ch, int bufferSize) {
        this.channel = ch;
        this.bufferSize = Math.max(16, bufferSize);
        this.maxChunkSize = this.bufferSize - 2;
        this.buffer = this.channel.alloc().buffer(this.bufferSize, this.bufferSize);
    }

    @Override
    public PackOutput flush() throws IOException {
        if (this.buffer != null && this.buffer.readableBytes() > 0) {
            this.closeChunkIfOpen();
            ByteBuf out = this.buffer;
            this.buffer = null;
            this.channel.writeAndFlush((Object)out, this.channel.voidPromise());
            this.newBuffer();
        }
        return this;
    }

    @Override
    public PackOutput writeByte(byte value) throws IOException {
        this.ensure(1);
        this.buffer.writeByte((int)value);
        return this;
    }

    @Override
    public PackOutput writeShort(short value) throws IOException {
        this.ensure(2);
        this.buffer.writeShort((int)value);
        return this;
    }

    @Override
    public PackOutput writeInt(int value) throws IOException {
        this.ensure(4);
        this.buffer.writeInt(value);
        return this;
    }

    @Override
    public PackOutput writeLong(long value) throws IOException {
        this.ensure(8);
        this.buffer.writeLong(value);
        return this;
    }

    @Override
    public PackOutput writeDouble(double value) throws IOException {
        this.ensure(8);
        this.buffer.writeDouble(value);
        return this;
    }

    @Override
    public PackOutput writeBytes(ByteBuffer data) throws IOException {
        while (data.remaining() > 0) {
            this.ensure(1);
            int oldLimit = data.limit();
            data.limit(data.position() + Math.min(this.buffer.writableBytes(), data.remaining()));
            this.buffer.writeBytes(data);
            data.limit(oldLimit);
        }
        return this;
    }

    @Override
    public PackOutput writeBytes(byte[] data, int offset, int length) throws IOException {
        if (offset + length > data.length) {
            throw new IOException("Asked to write " + length + " bytes, but there is only " + (data.length - offset) + " bytes available in data provided.");
        }
        return this.writeBytes(ByteBuffer.wrap(data, offset, length));
    }

    private void ensure(int size) throws IOException {
        int toWriteSize;
        assert (size <= this.maxChunkSize) : size + " > " + this.maxChunkSize;
        int n = toWriteSize = this.chunkOpen ? size : size + 2;
        if (this.buffer.writableBytes() < toWriteSize) {
            this.flush();
        }
        if (!this.chunkOpen) {
            this.currentChunkHeaderOffset = this.buffer.writerIndex();
            this.buffer.writerIndex(this.buffer.writerIndex() + 2);
            this.chunkOpen = true;
        }
    }

    private void closeChunkIfOpen() {
        if (this.chunkOpen) {
            int chunkSize = this.buffer.writerIndex() - (this.currentChunkHeaderOffset + 2);
            this.buffer.setShort(this.currentChunkHeaderOffset, chunkSize);
            this.chunkOpen = false;
        }
    }

    private void newBuffer() {
        this.buffer = this.channel.alloc().buffer(this.bufferSize, this.bufferSize);
        this.chunkOpen = false;
    }

    public void close() {
        if (this.buffer != null) {
            this.buffer.release();
            this.buffer = null;
        }
    }

    @Override
    public void onMessageComplete() throws IOException {
        this.closeChunkIfOpen();
        if (this.buffer.writableBytes() < 2) {
            this.flush();
        }
        this.buffer.writeShort(0);
        this.chunkOpen = false;
    }
}

