/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.apps;

import java.io.Serializable;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.Continuation;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.apps.Export;
import org.neo4j.shell.impl.AbstractApp;

public class Alias
extends AbstractApp {
    @Override
    public String getDescription() {
        return "Adds an alias so that it can be used later as a command.\nUsage: alias <key>=<value>";
    }

    @Override
    public Continuation execute(AppCommandParser parser, Session session, Output out) throws Exception {
        String line = parser.getLineWithoutApp();
        if (line.trim().length() == 0) {
            this.printAllAliases(session, out);
            return Continuation.INPUT_COMPLETE;
        }
        Pair<String, String> keyValue = Export.splitInKeyEqualsValue(line);
        String key = (String)keyValue.first();
        String value = (String)keyValue.other();
        if (value == null || value.trim().length() == 0) {
            session.removeAlias(key);
        } else {
            session.setAlias(key, value);
        }
        return Continuation.INPUT_COMPLETE;
    }

    private void printAllAliases(Session session, Output out) throws Exception {
        for (String key : session.getAliasKeys()) {
            out.println((Serializable)((Object)("alias " + key + "='" + session.getAlias(key) + "'")));
        }
    }
}

