/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.impl;

import java.io.File;
import org.neo4j.shell.Console;
import org.neo4j.shell.ShellClient;

public class JLineConsole
implements Console {
    private final Object consoleReader;

    static JLineConsole newConsoleOrNullIfNotFound(ShellClient client) {
        try {
            Object consoleReader = Class.forName("jline.console.ConsoleReader").newInstance();
            consoleReader.getClass().getMethod("setBellEnabled", Boolean.TYPE).invoke(consoleReader, false);
            consoleReader.getClass().getMethod("setExpandEvents", Boolean.TYPE).invoke(consoleReader, false);
            consoleReader.getClass().getMethod("setHistoryEnabled", Boolean.TYPE).invoke(consoleReader, true);
            Object completer = Class.forName(JLineConsole.class.getPackage().getName() + "." + "ShellTabCompleter").getConstructor(ShellClient.class).newInstance(client);
            Class<?> completerClass = Class.forName("jline.console.completer.Completer");
            consoleReader.getClass().getMethod("addCompleter", completerClass).invoke(consoleReader, completer);
            Class<?> historyClass = Class.forName("jline.console.history.History");
            Object history = Class.forName("jline.console.history.FileHistory").getConstructor(File.class).newInstance(new File(System.getProperty("user.home"), ".neo4j_shell_history"));
            consoleReader.getClass().getMethod("setHistory", historyClass).invoke(consoleReader, history);
            return new JLineConsole(consoleReader, client);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            return null;
        }
    }

    private JLineConsole(Object consoleReader, ShellClient client) {
        this.consoleReader = consoleReader;
    }

    @Override
    public void format(String format, Object ... args) {
        System.out.print(format);
    }

    @Override
    public String readLine(String prompt) {
        try {
            this.consoleReader.getClass().getMethod("setPrompt", String.class).invoke(this.consoleReader, prompt);
            Class<?> fileHistoryClass = Class.forName("jline.console.history.FileHistory");
            Object history = this.consoleReader.getClass().getMethod("getHistory", new Class[0]).invoke(this.consoleReader, new Object[0]);
            Class.forName("jline.console.history.FileHistory").getMethod("flush", new Class[0]).invoke(history, new Object[0]);
            return (String)this.consoleReader.getClass().getMethod("readLine", new Class[0]).invoke(this.consoleReader, new Object[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

