/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel;

import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.index.AutoIndexer;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.index.IndexPopulationProgress;
import org.neo4j.graphdb.index.RelationshipAutoIndexer;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.graphdb.traversal.BidirectionalTraversalDescription;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.helpers.collection.PrefetchingResourceIterator;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class ReadOnlyGraphDatabaseProxy
implements GraphDatabaseService,
GraphDatabaseAPI,
IndexManager {
    private final GraphDatabaseAPI actual;

    public ReadOnlyGraphDatabaseProxy(GraphDatabaseAPI graphDb) {
        this.actual = graphDb;
    }

    public Node readOnly(Node actual) {
        return new ReadOnlyNodeProxy(actual);
    }

    public Relationship readOnly(Relationship actual) {
        return new ReadOnlyRelationshipProxy(actual);
    }

    private static <T> T readOnly() {
        throw ReadOnlyGraphDatabaseProxy.readOnlyException();
    }

    private static UnsupportedOperationException readOnlyException() {
        return new UnsupportedOperationException("Read only Graph Database!");
    }

    @Override
    public InternalTransaction beginTransaction(KernelTransaction.Type type, AccessMode accessMode) {
        return this.actual.beginTransaction(type, accessMode);
    }

    public Transaction beginTx() {
        return this.actual.beginTx();
    }

    public Result execute(String query) {
        return this.execute(query, Collections.emptyMap());
    }

    public Result execute(String query, Map<String, Object> parameters) {
        return (Result)ReadOnlyGraphDatabaseProxy.readOnly();
    }

    public Node createNode() {
        return (Node)ReadOnlyGraphDatabaseProxy.readOnly();
    }

    public Node createNode(Label ... labels) {
        return (Node)ReadOnlyGraphDatabaseProxy.readOnly();
    }

    public boolean enableRemoteShell() {
        throw new UnsupportedOperationException("Cannot enable Remote Shell from Remote Shell");
    }

    public boolean enableRemoteShell(Map<String, Serializable> initialProperties) {
        return this.enableRemoteShell();
    }

    public ResourceIterable<Node> getAllNodes() {
        return this.nodes((ResourceIterable<Node>)this.actual.getAllNodes());
    }

    public Node getNodeById(long id) {
        return new ReadOnlyNodeProxy(this.actual.getNodeById(id));
    }

    public Relationship getRelationshipById(long id) {
        return new ReadOnlyRelationshipProxy(this.actual.getRelationshipById(id));
    }

    public ResourceIterable<Relationship> getAllRelationships() {
        return new ResourceIterable<Relationship>(){

            public ResourceIterator<Relationship> iterator() {
                final ResourceIterator iterator = ReadOnlyGraphDatabaseProxy.this.actual.getAllRelationships().iterator();
                return new PrefetchingResourceIterator<Relationship>(){

                    protected Relationship fetchNextOrNull() {
                        return new ReadOnlyRelationshipProxy((Relationship)iterator.next());
                    }

                    public void close() {
                        iterator.close();
                    }
                };
            }
        };
    }

    public ResourceIterable<Label> getAllLabelsInUse() {
        return this.actual.getAllLabelsInUse();
    }

    public ResourceIterable<RelationshipType> getAllRelationshipTypesInUse() {
        return this.actual.getAllRelationshipTypesInUse();
    }

    public ResourceIterable<Label> getAllLabels() {
        return this.actual.getAllLabels();
    }

    public ResourceIterable<RelationshipType> getAllRelationshipTypes() {
        return this.actual.getAllRelationshipTypes();
    }

    public ResourceIterable<String> getAllPropertyKeys() {
        return this.actual.getAllPropertyKeys();
    }

    public KernelEventHandler registerKernelEventHandler(KernelEventHandler handler) {
        return (KernelEventHandler)ReadOnlyGraphDatabaseProxy.readOnly();
    }

    public <T> TransactionEventHandler<T> registerTransactionEventHandler(TransactionEventHandler<T> handler) {
        return (TransactionEventHandler)ReadOnlyGraphDatabaseProxy.readOnly();
    }

    public boolean isAvailable(long timeout) {
        return this.actual.isAvailable(timeout);
    }

    public void shutdown() {
        this.actual.shutdown();
    }

    public KernelEventHandler unregisterKernelEventHandler(KernelEventHandler handler) {
        return (KernelEventHandler)ReadOnlyGraphDatabaseProxy.readOnly();
    }

    public Schema schema() {
        return new ReadOnlySchemaProxy(this.actual.schema());
    }

    public <T> TransactionEventHandler<T> unregisterTransactionEventHandler(TransactionEventHandler<T> handler) {
        return (TransactionEventHandler)ReadOnlyGraphDatabaseProxy.readOnly();
    }

    public ResourceIterable<Node> nodes(ResourceIterable<Node> nodes) {
        return () -> nodes.iterator().map(x$0 -> new ReadOnlyNodeProxy((Node)x$0));
    }

    public Iterable<Relationship> relationships(Iterable<Relationship> relationships) {
        return new IterableWrapper<Relationship, Relationship>(relationships){

            protected Relationship underlyingObjectToObject(Relationship relationship) {
                return new ReadOnlyRelationshipProxy(relationship);
            }
        };
    }

    public boolean existsForNodes(String indexName) {
        return this.actual.index().existsForNodes(indexName);
    }

    public Index<Node> forNodes(String indexName) {
        return new ReadOnlyNodeIndexProxy((Index<Node>)this.actual.index().forNodes(indexName, null));
    }

    public Index<Node> forNodes(String indexName, Map<String, String> customConfiguration) {
        return new ReadOnlyNodeIndexProxy((Index<Node>)this.actual.index().forNodes(indexName, customConfiguration));
    }

    public String[] nodeIndexNames() {
        return this.actual.index().nodeIndexNames();
    }

    public boolean existsForRelationships(String indexName) {
        return this.actual.index().existsForRelationships(indexName);
    }

    public RelationshipIndex forRelationships(String indexName) {
        return new ReadOnlyRelationshipIndexProxy(this.actual.index().forRelationships(indexName, null));
    }

    public RelationshipIndex forRelationships(String indexName, Map<String, String> customConfiguration) {
        return new ReadOnlyRelationshipIndexProxy(this.actual.index().forRelationships(indexName, customConfiguration));
    }

    public String[] relationshipIndexNames() {
        return this.actual.index().relationshipIndexNames();
    }

    public IndexManager index() {
        return this;
    }

    public TraversalDescription traversalDescription() {
        return this.actual.traversalDescription();
    }

    public BidirectionalTraversalDescription bidirectionalTraversalDescription() {
        return this.actual.bidirectionalTraversalDescription();
    }

    public Map<String, String> getConfiguration(Index<? extends PropertyContainer> index) {
        return this.actual.index().getConfiguration(index);
    }

    public String setConfiguration(Index<? extends PropertyContainer> index, String key, String value) {
        throw new IllegalStateException("Database is in read-only mode");
    }

    public String removeConfiguration(Index<? extends PropertyContainer> index, String key) {
        throw new IllegalStateException("Database is in read-only mode");
    }

    public AutoIndexer<Node> getNodeAutoIndexer() {
        return this.actual.index().getNodeAutoIndexer();
    }

    public RelationshipAutoIndexer getRelationshipAutoIndexer() {
        return this.actual.index().getRelationshipAutoIndexer();
    }

    @Override
    public DependencyResolver getDependencyResolver() {
        return this.actual.getDependencyResolver();
    }

    @Override
    public String getStoreDir() {
        return this.actual.getStoreDir();
    }

    @Override
    public StoreId storeId() {
        return this.actual.storeId();
    }

    @Override
    public URL validateURLAccess(URL url) throws URLAccessValidationError {
        return this.actual.validateURLAccess(url);
    }

    public ResourceIterator<Node> findNodes(Label label, String key, Object value) {
        return this.actual.findNodes(label, key, value);
    }

    public Node findNode(Label label, String key, Object value) {
        return this.actual.findNode(label, key, value);
    }

    public ResourceIterator<Node> findNodes(Label label) {
        return this.actual.findNodes(label);
    }

    private class ReadOnlySchemaProxy
    implements Schema {
        private final Schema actual;

        public ReadOnlySchemaProxy(Schema actual) {
            this.actual = actual;
        }

        public IndexCreator indexFor(Label label) {
            throw ReadOnlyGraphDatabaseProxy.readOnlyException();
        }

        public Iterable<IndexDefinition> getIndexes(Label label) {
            return this.actual.getIndexes(label);
        }

        public Iterable<IndexDefinition> getIndexes() {
            return this.actual.getIndexes();
        }

        public Schema.IndexState getIndexState(IndexDefinition index) {
            return this.actual.getIndexState(index);
        }

        public IndexPopulationProgress getIndexPopulationProgress(IndexDefinition index) {
            return this.actual.getIndexPopulationProgress(index);
        }

        public String getIndexFailure(IndexDefinition index) {
            return this.actual.getIndexFailure(index);
        }

        public void awaitIndexOnline(IndexDefinition index, long duration, TimeUnit unit) {
            this.actual.awaitIndexOnline(index, duration, unit);
        }

        public void awaitIndexesOnline(long duration, TimeUnit unit) {
            this.actual.awaitIndexesOnline(duration, unit);
        }

        public ConstraintCreator constraintFor(Label label) {
            throw ReadOnlyGraphDatabaseProxy.readOnlyException();
        }

        public Iterable<ConstraintDefinition> getConstraints() {
            return this.actual.getConstraints();
        }

        public Iterable<ConstraintDefinition> getConstraints(Label label) {
            return this.actual.getConstraints(label);
        }

        public Iterable<ConstraintDefinition> getConstraints(RelationshipType type) {
            return this.actual.getConstraints(type);
        }
    }

    private static class ReadOnlyIndexHitsProxy<T extends PropertyContainer>
    implements IndexHits<T> {
        private final ReadOnlyIndexProxy<T, ?> index;
        private final IndexHits<T> actual;

        ReadOnlyIndexHitsProxy(ReadOnlyIndexProxy<T, ?> index, IndexHits<T> actual) {
            this.index = index;
            this.actual = actual;
        }

        public void close() {
            this.actual.close();
        }

        public T getSingle() {
            return (T)this.index.wrap((PropertyContainer)this.actual.getSingle());
        }

        public int size() {
            return this.actual.size();
        }

        public boolean hasNext() {
            return this.actual.hasNext();
        }

        public T next() {
            return (T)this.index.wrap((PropertyContainer)this.actual.next());
        }

        public void remove() {
            ReadOnlyGraphDatabaseProxy.readOnly();
        }

        public ResourceIterator<T> iterator() {
            return this;
        }

        public float currentScore() {
            return this.actual.currentScore();
        }
    }

    class ReadOnlyRelationshipIndexProxy
    extends ReadOnlyIndexProxy<Relationship, RelationshipIndex>
    implements RelationshipIndex {
        ReadOnlyRelationshipIndexProxy(RelationshipIndex actual) {
            super(ReadOnlyGraphDatabaseProxy.this, (Index)actual);
        }

        @Override
        Relationship wrap(Relationship actual) {
            return ReadOnlyGraphDatabaseProxy.this.readOnly(actual);
        }

        public IndexHits<Relationship> get(String key, Object valueOrNull, Node startNodeOrNull, Node endNodeOrNull) {
            return new ReadOnlyIndexHitsProxy<Relationship>(this, ((RelationshipIndex)this.actual).get(key, valueOrNull, startNodeOrNull, endNodeOrNull));
        }

        public IndexHits<Relationship> query(String key, Object queryOrQueryObjectOrNull, Node startNodeOrNull, Node endNodeOrNull) {
            return new ReadOnlyIndexHitsProxy<Relationship>(this, ((RelationshipIndex)this.actual).query(key, queryOrQueryObjectOrNull, startNodeOrNull, endNodeOrNull));
        }

        public IndexHits<Relationship> query(Object queryOrQueryObjectOrNull, Node startNodeOrNull, Node endNodeOrNull) {
            return new ReadOnlyIndexHitsProxy<Relationship>(this, ((RelationshipIndex)this.actual).query(queryOrQueryObjectOrNull, startNodeOrNull, endNodeOrNull));
        }

        public String getName() {
            return ((RelationshipIndex)this.actual).getName();
        }

        public Class<Relationship> getEntityType() {
            return Relationship.class;
        }
    }

    class ReadOnlyNodeIndexProxy
    extends ReadOnlyIndexProxy<Node, Index<Node>> {
        ReadOnlyNodeIndexProxy(Index<Node> actual) {
            super(ReadOnlyGraphDatabaseProxy.this, actual);
        }

        @Override
        Node wrap(Node actual) {
            return ReadOnlyGraphDatabaseProxy.this.readOnly(actual);
        }

        public String getName() {
            return this.actual.getName();
        }

        public Class<Node> getEntityType() {
            return Node.class;
        }
    }

    static abstract class ReadOnlyIndexProxy<T extends PropertyContainer, I extends Index<T>>
    implements Index<T> {
        final I actual;
        final /* synthetic */ ReadOnlyGraphDatabaseProxy this$0;

        ReadOnlyIndexProxy(I actual) {
            this.this$0 = this$0;
            this.actual = actual;
        }

        abstract T wrap(T var1);

        public void delete() {
            ReadOnlyGraphDatabaseProxy.readOnly();
        }

        public void add(T entity, String key, Object value) {
            ReadOnlyGraphDatabaseProxy.readOnly();
        }

        public T putIfAbsent(T entity, String key, Object value) {
            ReadOnlyGraphDatabaseProxy.readOnly();
            return null;
        }

        public IndexHits<T> get(String key, Object value) {
            return new ReadOnlyIndexHitsProxy(this, this.actual.get(key, value));
        }

        public IndexHits<T> query(String key, Object queryOrQueryObject) {
            return new ReadOnlyIndexHitsProxy(this, this.actual.query(key, queryOrQueryObject));
        }

        public IndexHits<T> query(Object queryOrQueryObject) {
            return new ReadOnlyIndexHitsProxy(this, this.actual.query(queryOrQueryObject));
        }

        public void remove(T entity, String key, Object value) {
            ReadOnlyGraphDatabaseProxy.readOnly();
        }

        public void remove(T entity, String key) {
            ReadOnlyGraphDatabaseProxy.readOnly();
        }

        public void remove(T entity) {
            ReadOnlyGraphDatabaseProxy.readOnly();
        }

        public boolean isWriteable() {
            return false;
        }

        public GraphDatabaseService getGraphDatabase() {
            return this.actual.getGraphDatabase();
        }
    }

    private class ReadOnlyRelationshipProxy
    implements Relationship {
        private final Relationship actual;

        ReadOnlyRelationshipProxy(Relationship actual) {
            this.actual = actual;
        }

        public int hashCode() {
            return this.actual.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Relationship && ((Relationship)obj).getId() == this.getId();
        }

        public String toString() {
            return this.actual.toString();
        }

        public long getId() {
            return this.actual.getId();
        }

        public void delete() {
            ReadOnlyGraphDatabaseProxy.readOnly();
        }

        public Node getEndNode() {
            return new ReadOnlyNodeProxy(this.actual.getEndNode());
        }

        public Node[] getNodes() {
            return new Node[]{this.getStartNode(), this.getEndNode()};
        }

        public Node getOtherNode(Node node) {
            return new ReadOnlyNodeProxy(this.actual.getOtherNode(node));
        }

        public Node getStartNode() {
            return new ReadOnlyNodeProxy(this.actual.getStartNode());
        }

        public RelationshipType getType() {
            return this.actual.getType();
        }

        public boolean isType(RelationshipType type) {
            return this.actual.isType(type);
        }

        public GraphDatabaseService getGraphDatabase() {
            return ReadOnlyGraphDatabaseProxy.this;
        }

        public Object getProperty(String key) {
            return this.actual.getProperty(key);
        }

        public Object getProperty(String key, Object defaultValue) {
            return this.actual.getProperty(key, defaultValue);
        }

        public Iterable<String> getPropertyKeys() {
            return this.actual.getPropertyKeys();
        }

        public Map<String, Object> getProperties(String ... names) {
            return this.actual.getProperties(names);
        }

        public Map<String, Object> getAllProperties() {
            return this.actual.getAllProperties();
        }

        public boolean hasProperty(String key) {
            return this.actual.hasProperty(key);
        }

        public Object removeProperty(String key) {
            return ReadOnlyGraphDatabaseProxy.readOnly();
        }

        public void setProperty(String key, Object value) {
            ReadOnlyGraphDatabaseProxy.readOnly();
        }
    }

    private class ReadOnlyNodeProxy
    implements Node {
        private final Node actual;

        ReadOnlyNodeProxy(Node actual) {
            this.actual = actual;
        }

        public int hashCode() {
            return this.actual.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Node && ((Node)obj).getId() == this.getId();
        }

        public String toString() {
            return this.actual.toString();
        }

        public long getId() {
            return this.actual.getId();
        }

        public Relationship createRelationshipTo(Node otherNode, RelationshipType type) {
            return (Relationship)ReadOnlyGraphDatabaseProxy.readOnly();
        }

        public void delete() {
            ReadOnlyGraphDatabaseProxy.readOnly();
        }

        public Iterable<Relationship> getRelationships() {
            return ReadOnlyGraphDatabaseProxy.this.relationships(this.actual.getRelationships());
        }

        public Iterable<Relationship> getRelationships(RelationshipType ... types) {
            return ReadOnlyGraphDatabaseProxy.this.relationships(this.actual.getRelationships(types));
        }

        public Iterable<Relationship> getRelationships(Direction direction, RelationshipType ... types) {
            return ReadOnlyGraphDatabaseProxy.this.relationships(this.actual.getRelationships(direction, types));
        }

        public Iterable<Relationship> getRelationships(Direction dir) {
            return ReadOnlyGraphDatabaseProxy.this.relationships(this.actual.getRelationships(dir));
        }

        public Iterable<Relationship> getRelationships(RelationshipType type, Direction dir) {
            return ReadOnlyGraphDatabaseProxy.this.relationships(this.actual.getRelationships(type, dir));
        }

        public Relationship getSingleRelationship(RelationshipType type, Direction dir) {
            return new ReadOnlyRelationshipProxy(this.actual.getSingleRelationship(type, dir));
        }

        public boolean hasRelationship() {
            return this.actual.hasRelationship();
        }

        public boolean hasRelationship(RelationshipType ... types) {
            return this.actual.hasRelationship(types);
        }

        public boolean hasRelationship(Direction direction, RelationshipType ... types) {
            return this.actual.hasRelationship(direction, types);
        }

        public boolean hasRelationship(Direction dir) {
            return this.actual.hasRelationship(dir);
        }

        public boolean hasRelationship(RelationshipType type, Direction dir) {
            return this.actual.hasRelationship(type, dir);
        }

        public void addLabel(Label label) {
            ReadOnlyGraphDatabaseProxy.readOnly();
        }

        public void removeLabel(Label label) {
            ReadOnlyGraphDatabaseProxy.readOnly();
        }

        public boolean hasLabel(Label label) {
            return this.actual.hasLabel(label);
        }

        public Iterable<Label> getLabels() {
            return this.actual.getLabels();
        }

        public GraphDatabaseService getGraphDatabase() {
            return ReadOnlyGraphDatabaseProxy.this;
        }

        public Object getProperty(String key) {
            return this.actual.getProperty(key);
        }

        public Object getProperty(String key, Object defaultValue) {
            return this.actual.getProperty(key, defaultValue);
        }

        public Iterable<String> getPropertyKeys() {
            return this.actual.getPropertyKeys();
        }

        public Map<String, Object> getProperties(String ... names) {
            return this.actual.getProperties(names);
        }

        public Map<String, Object> getAllProperties() {
            return this.actual.getAllProperties();
        }

        public boolean hasProperty(String key) {
            return this.actual.hasProperty(key);
        }

        public Object removeProperty(String key) {
            return ReadOnlyGraphDatabaseProxy.readOnly();
        }

        public void setProperty(String key, Object value) {
            ReadOnlyGraphDatabaseProxy.readOnly();
        }

        public Iterable<RelationshipType> getRelationshipTypes() {
            return null;
        }

        public int getDegree() {
            return this.actual.getDegree();
        }

        public int getDegree(RelationshipType type) {
            return this.actual.getDegree(type);
        }

        public int getDegree(Direction direction) {
            return this.actual.getDegree(direction);
        }

        public int getDegree(RelationshipType type, Direction direction) {
            return this.actual.getDegree(type, direction);
        }
    }
}

