/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.Continuation;
import org.neo4j.shell.OptionDefinition;
import org.neo4j.shell.OptionValueType;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.kernel.apps.NodeOrRelationship;
import org.neo4j.shell.kernel.apps.TransactionProvidingApp;

public class Mv
extends TransactionProvidingApp {
    public Mv() {
        this.addOptionDefinition("o", new OptionDefinition(OptionValueType.NONE, "To override if the key already exists"));
    }

    @Override
    public String getDescription() {
        return "Renames a property on a node or relationship. Usage: mv <key> <new-key>";
    }

    @Override
    protected Continuation exec(AppCommandParser parser, Session session, Output out) throws ShellException {
        if (parser.arguments().size() < 2) {
            throw new ShellException("Must supply <from-key> <to-key> arguments, like: mv name \"given_name\"");
        }
        String fromKey = parser.arguments().get(0);
        String toKey = parser.arguments().get(1);
        boolean mayOverwrite = parser.options().containsKey("o");
        NodeOrRelationship thing = this.getCurrent(session);
        if (!thing.hasProperty(fromKey)) {
            throw new ShellException("Property '" + fromKey + "' doesn't exist");
        }
        if (thing.hasProperty(toKey)) {
            if (!mayOverwrite) {
                throw new ShellException("Property '" + toKey + "' already exists, supply -o flag to overwrite");
            }
            thing.removeProperty(toKey);
        }
        Object value = thing.removeProperty(fromKey);
        thing.setProperty(toKey, value);
        return Continuation.INPUT_COMPLETE;
    }
}

