/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import java.io.Serializable;
import java.rmi.RemoteException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.Continuation;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.kernel.apps.Begin;
import org.neo4j.shell.kernel.apps.Commit;
import org.neo4j.shell.kernel.apps.NonTransactionProvidingApp;

public class Rollback
extends NonTransactionProvidingApp {
    @Override
    public String getDescription() {
        return "Rolls back all open transactions";
    }

    @Override
    protected Continuation exec(AppCommandParser parser, Session session, Output out) throws ShellException, RemoteException {
        if (parser.getLineWithoutApp().trim().length() > 0) {
            out.println((Serializable)((Object)"Error: ROLLBACK should  be run without trailing arguments"));
            return Continuation.INPUT_COMPLETE;
        }
        KernelTransaction tx = Begin.currentTransaction(this.getServer());
        if (tx == null) {
            throw Commit.fail(session, "Not in a transaction");
        }
        session.remove("TX_COUNT");
        tx.failure();
        try {
            tx.close();
        }
        catch (TransactionFailureException e) {
            throw new ShellException(e.getMessage());
        }
        out.println((Serializable)((Object)"Transaction rolled back"));
        return Continuation.INPUT_COMPLETE;
    }
}

