/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.constraints;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.constraints.NodePropertyConstraint;
import org.neo4j.kernel.api.constraints.PropertyConstraint;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;

public class NodePropertyExistenceConstraint
extends NodePropertyConstraint {
    public NodePropertyExistenceConstraint(int labelId, int propertyKeyId) {
        super(labelId, propertyKeyId);
    }

    @Override
    public void added(PropertyConstraint.ChangeVisitor visitor) throws CreateConstraintFailureException {
        visitor.visitAddedNodePropertyExistenceConstraint(this);
    }

    @Override
    public void removed(PropertyConstraint.ChangeVisitor visitor) {
        visitor.visitRemovedNodePropertyExistenceConstraint(this);
    }

    @Override
    public String userDescription(TokenNameLookup tokenNameLookup) {
        String labelName = tokenNameLookup.labelGetName(this.labelId);
        String boundIdentifier = labelName.toLowerCase();
        return String.format("CONSTRAINT ON ( %s:%s ) ASSERT exists(%s.%s)", boundIdentifier, labelName, boundIdentifier, tokenNameLookup.propertyKeyGetName(this.propertyKeyId));
    }

    @Override
    public String toString() {
        return String.format("CONSTRAINT ON ( n:label[%s] ) ASSERT exists(n.property[%s])", this.labelId, this.propertyKeyId);
    }
}

