/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.exceptions.schema.ConstraintViolationKernelException;

public class NodePropertyExistenceConstraintViolationKernelException
extends ConstraintViolationKernelException {
    private final int labelId;
    private final int propertyKeyId;
    private final long nodeId;

    public NodePropertyExistenceConstraintViolationKernelException(int labelId, int propertyKeyId, long nodeId) {
        super("Node %d with label %d must have the property %d", nodeId, labelId, propertyKeyId);
        this.labelId = labelId;
        this.propertyKeyId = propertyKeyId;
        this.nodeId = nodeId;
    }

    @Override
    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        return String.format("Node %d with label \"%s\" must have the property \"%s\" due to a constraint", this.nodeId, tokenNameLookup.labelGetName(this.labelId), tokenNameLookup.propertyKeyGetName(this.propertyKeyId));
    }

    public int labelId() {
        return this.labelId;
    }

    public int propertyKeyId() {
        return this.propertyKeyId;
    }
}

