/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintVerificationFailedKernelException;

public class UniquenessConstraintVerificationFailedKernelException
extends ConstraintVerificationFailedKernelException {
    private final UniquenessConstraint constraint;
    private final Set<IndexEntryConflictException> conflicts;

    public UniquenessConstraintVerificationFailedKernelException(UniquenessConstraint constraint, Set<IndexEntryConflictException> conflicts) {
        super(constraint);
        this.constraint = constraint;
        this.conflicts = conflicts;
    }

    public UniquenessConstraintVerificationFailedKernelException(UniquenessConstraint constraint, Throwable cause) {
        super(constraint, cause);
        this.constraint = constraint;
        this.conflicts = Collections.emptySet();
    }

    @Override
    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        StringBuilder message = new StringBuilder();
        Iterator<IndexEntryConflictException> iterator = this.conflicts.iterator();
        while (iterator.hasNext()) {
            IndexEntryConflictException conflict = iterator.next();
            message.append(conflict.evidenceMessage(tokenNameLookup.labelGetName(this.constraint.label()), tokenNameLookup.propertyKeyGetName(this.constraint.propertyKey())));
            if (!iterator.hasNext()) continue;
            message.append(System.lineSeparator());
        }
        return message.toString();
    }

    @Override
    public UniquenessConstraint constraint() {
        return this.constraint;
    }
}

