/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.neo4j.collection.PrefetchingRawIterator;
import org.neo4j.collection.RawIterator;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.impl.proc.ReflectiveProcedureCompiler;
import org.neo4j.logging.Log;

public class ProcedureJarLoader {
    private final ReflectiveProcedureCompiler compiler;
    private final Log log;

    public ProcedureJarLoader(ReflectiveProcedureCompiler compiler, Log log) {
        this.compiler = compiler;
        this.log = log;
    }

    public List<CallableProcedure> loadProcedures(URL jar) throws Exception {
        return this.loadProcedures(jar, new URLClassLoader(new URL[]{jar}, this.getClass().getClassLoader()), new LinkedList<CallableProcedure>());
    }

    public List<CallableProcedure> loadProceduresFromDir(File root) throws IOException, KernelException {
        if (!root.exists()) {
            return Collections.emptyList();
        }
        LinkedList<CallableProcedure> out = new LinkedList<CallableProcedure>();
        List<URL> list = Stream.of(root.listFiles((dir, name) -> name.endsWith(".jar"))).map(this::toURL).collect(Collectors.toList());
        URL[] jarFiles = list.toArray(new URL[list.size()]);
        URLClassLoader loader = new URLClassLoader(jarFiles, this.getClass().getClassLoader());
        for (URL jarFile : jarFiles) {
            this.loadProcedures(jarFile, loader, out);
        }
        return out;
    }

    private List<CallableProcedure> loadProcedures(URL jar, ClassLoader loader, List<CallableProcedure> target) throws IOException, KernelException {
        RawIterator<Class<?>, IOException> classes = this.listClassesIn(jar, loader);
        while (classes.hasNext()) {
            Class next = (Class)classes.next();
            target.addAll(this.compiler.compile(next));
        }
        return target;
    }

    private URL toURL(File f) {
        try {
            return f.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private RawIterator<Class<?>, IOException> listClassesIn(final URL jar, final ClassLoader loader) throws IOException {
        final ZipInputStream zip = new ZipInputStream(jar.openStream());
        return new PrefetchingRawIterator<Class<?>, IOException>(){

            protected Class<?> fetchNextOrNull() throws IOException {
                try {
                    while (true) {
                        ZipEntry nextEntry;
                        if ((nextEntry = zip.getNextEntry()) == null) {
                            zip.close();
                            return null;
                        }
                        String name = nextEntry.getName();
                        if (!name.endsWith(".class")) continue;
                        String className = name.substring(0, name.length() - ".class".length()).replace("/", ".");
                        try {
                            Class<?> aClass = loader.loadClass(className);
                            aClass.getDeclaredMethods();
                            return aClass;
                        }
                        catch (Exception | NoClassDefFoundError | UnsatisfiedLinkError e) {
                            ProcedureJarLoader.this.log.warn("Failed to load `%s` from plugin jar `%s`: %s", new Object[]{className, jar.getFile(), e.getMessage()});
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException | RuntimeException e) {
                    zip.close();
                    throw e;
                }
            }
        };
    }
}

