/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.dbms.DbmsOperations;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;
import org.neo4j.kernel.impl.query.TransactionalContext;

public class Neo4jTransactionalContext
implements TransactionalContext {
    private final GraphDatabaseQueryService graph;
    private final ThreadToStatementContextBridge txBridge;
    private final KernelTransaction.Type transactionType;
    private final AccessMode mode;
    private final DbmsOperations dbmsOperations;
    private InternalTransaction transaction;
    private Statement statement;
    private PropertyContainerLocker locker;
    private boolean isOpen = true;

    public Neo4jTransactionalContext(GraphDatabaseQueryService graph, InternalTransaction initialTransaction, Statement initialStatement, PropertyContainerLocker locker) {
        this.graph = graph;
        this.transaction = initialTransaction;
        this.transactionType = initialTransaction.transactionType();
        this.mode = initialTransaction.mode();
        this.statement = initialStatement;
        this.locker = locker;
        this.txBridge = (ThreadToStatementContextBridge)graph.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
        this.dbmsOperations = (DbmsOperations)graph.getDependencyResolver().resolveDependency(DbmsOperations.class);
    }

    @Override
    public ReadOperations readOperations() {
        return this.statement.readOperations();
    }

    @Override
    public DbmsOperations dbmsOperations() {
        return this.dbmsOperations;
    }

    @Override
    public boolean isTopLevelTx() {
        return this.transaction.transactionType() == KernelTransaction.Type.implicit;
    }

    @Override
    public void close(boolean success) {
        if (this.isOpen) {
            try {
                this.statement.close();
                if (success) {
                    this.transaction.success();
                } else {
                    this.transaction.failure();
                }
                this.transaction.close();
            }
            finally {
                this.statement = null;
                this.transaction = null;
                this.isOpen = false;
            }
        }
    }

    @Override
    public void commitAndRestartTx() {
        this.transaction.success();
        this.transaction.close();
        this.transaction = this.graph.beginTransaction(this.transactionType, this.mode);
        this.statement = this.txBridge.get();
    }

    @Override
    public void cleanForReuse() {
        this.statement.close();
        this.statement = this.txBridge.get();
    }

    @Override
    public TransactionalContext provideContext() {
        if (this.isOpen) {
            return this;
        }
        InternalTransaction transaction = this.graph.beginTransaction(this.transactionType, this.mode);
        Statement statement = this.txBridge.get();
        return new Neo4jTransactionalContext(this.graph, transaction, statement, this.locker);
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public GraphDatabaseQueryService graph() {
        return this.graph;
    }

    @Override
    public Statement statement() {
        return this.statement;
    }

    @Override
    public TxStateHolder stateView() {
        return (KernelStatement)this.statement;
    }

    @Override
    public Lock acquireWriteLock(PropertyContainer p) {
        return this.locker.exclusiveLock(() -> this.statement, p);
    }

    @Override
    public KernelTransaction.Revertable restrictCurrentTransaction(AccessMode accessMode) {
        return this.transaction.restrict(accessMode);
    }

    @Override
    public AccessMode accessMode() {
        return this.mode;
    }
}

