/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.Iterator;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.id.IdSequence;
import org.neo4j.kernel.impl.store.record.DynamicRecord;

class ExistingThenNewRecordAllocator
implements DynamicRecordAllocator {
    private final int recordDataSize;
    private final IdSequence idSequence;

    ExistingThenNewRecordAllocator(int recordDataSize, IdSequence idSequence) {
        this.recordDataSize = recordDataSize;
        this.idSequence = idSequence;
    }

    @Override
    public DynamicRecord nextUsedRecordOrNew(Iterator<DynamicRecord> recordsToUseFirst) {
        DynamicRecord record;
        if (recordsToUseFirst.hasNext()) {
            record = recordsToUseFirst.next();
            if (!record.inUse()) {
                record.setCreated();
            }
        } else {
            record = new DynamicRecord(this.idSequence.nextId());
            record.setCreated();
        }
        record.setInUse(true);
        return record;
    }

    @Override
    public int getRecordDataSize() {
        return this.recordDataSize;
    }
}

