/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacylogs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.Function;
import org.neo4j.cursor.IOCursor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.storemigration.legacylogs.LegacyLogFilenames;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.PositionAwarePhysicalFlushableChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderWriter;
import org.neo4j.storageengine.api.StorageCommand;

class LegacyLogEntryWriter {
    private static final Function<FlushableChannel, LogEntryWriter> defaultLogEntryWriterFactory = LogEntryWriter::new;
    private final FileSystemAbstraction fs;
    private final Function<FlushableChannel, LogEntryWriter> factory;

    LegacyLogEntryWriter(FileSystemAbstraction fs) {
        this(fs, defaultLogEntryWriterFactory);
    }

    LegacyLogEntryWriter(FileSystemAbstraction fs, Function<FlushableChannel, LogEntryWriter> factory) {
        this.fs = fs;
        this.factory = factory;
    }

    public LogVersionedStoreChannel openWritableChannel(File file) throws IOException {
        StoreChannel storeChannel = this.fs.open(file, "rw");
        long version = LegacyLogFilenames.getLegacyLogVersion(file.getName());
        return new PhysicalLogVersionedStoreChannel(storeChannel, version, 6);
    }

    public void writeLogHeader(LogVersionedStoreChannel channel, LogHeader header) throws IOException {
        LogHeaderWriter.writeLogHeader(channel, header.logVersion, header.lastCommittedTxId);
    }

    public void writeAllLogEntries(LogVersionedStoreChannel channel, IOCursor<LogEntry> cursor) throws IOException {
        try (PositionAwarePhysicalFlushableChannel writable = new PositionAwarePhysicalFlushableChannel(channel);){
            LogEntryWriter writer = this.factory.apply(writable);
            ArrayList<StorageCommand> commands = new ArrayList<StorageCommand>();
            while (cursor.next()) {
                LogEntry entry = (LogEntry)cursor.get();
                if (entry instanceof LogEntryStart) {
                    LogEntryStart startEntry = (LogEntryStart)entry.as();
                    writer.writeStartEntry(startEntry.getMasterId(), startEntry.getLocalId(), startEntry.getTimeWritten(), startEntry.getLastCommittedTxWhenTransactionStarted(), startEntry.getAdditionalHeader());
                    continue;
                }
                if (entry instanceof LogEntryCommit) {
                    if (!commands.isEmpty()) {
                        writer.serialize(new PhysicalTransactionRepresentation(commands));
                        commands = new ArrayList();
                    }
                    LogEntryCommit commitEntry = (LogEntryCommit)entry;
                    writer.writeCommitEntry(commitEntry.getTxId(), commitEntry.getTimeWritten());
                    continue;
                }
                if (entry instanceof LogEntryCommand) {
                    commands.add(((LogEntryCommand)entry).getXaCommand());
                    continue;
                }
                throw new IllegalStateException("Unknown entry: " + entry);
            }
        }
    }
}

