/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacylogs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.cursor.IOCursor;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.IdentifiableLogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;

class LogEntrySortingCursor
implements IOCursor<LogEntry> {
    private final ReadableLogChannel channel;
    private final LogEntryReader<ReadableLogChannel> reader;
    private final Map<Integer, List<LogEntry>> idToEntries = new HashMap<Integer, List<LogEntry>>();
    private LogEntry toReturn;
    private int idToFetchFrom = -1;

    LogEntrySortingCursor(LogEntryReader<ReadableLogChannel> reader, ReadableLogChannel channel) {
        this.reader = reader;
        this.channel = channel;
    }

    public LogEntry get() {
        return this.toReturn;
    }

    public boolean next() throws IOException {
        this.perhapsFetchEntriesFromChannel();
        if (this.idToFetchFrom < 0) {
            this.toReturn = null;
            return false;
        }
        List<LogEntry> entries = this.idToEntries.get(this.idToFetchFrom);
        this.toReturn = entries.remove(0);
        if (entries.isEmpty()) {
            this.idToEntries.remove(this.idToFetchFrom);
            this.idToFetchFrom = -1;
        }
        return true;
    }

    private void perhapsFetchEntriesFromChannel() throws IOException {
        LogEntry entry;
        if (this.idToFetchFrom > 0) {
            return;
        }
        while ((entry = this.reader.readLogEntry(this.channel)) != null) {
            if (!(entry instanceof IdentifiableLogEntry)) {
                throw new IllegalStateException("reading from a log which is not a legacy one???");
            }
            IdentifiableLogEntry identifiableLogEntry = (IdentifiableLogEntry)entry;
            int identifier = identifiableLogEntry.getIdentifier();
            LogEntry inner = identifiableLogEntry.getEntry();
            List<LogEntry> list = this.provideList(this.idToEntries, identifier);
            list.add(inner);
            if (!(inner instanceof LogEntryCommit)) continue;
            this.idToFetchFrom = identifier;
            break;
        }
    }

    private List<LogEntry> provideList(Map<Integer, List<LogEntry>> idToEntries, int identifier) {
        List<LogEntry> list = idToEntries.get(identifier);
        if (list == null) {
            list = new ArrayList<LogEntry>();
            idToEntries.put(identifier, list);
        }
        return list;
    }

    public void close() throws IOException {
        this.channel.close();
    }
}

