/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.participant;

import java.io.File;
import java.io.IOException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.store.format.CapabilityType;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;
import org.neo4j.kernel.impl.storemigration.participant.AbstractStoreMigrationParticipant;

public class SchemaIndexMigrator
extends AbstractStoreMigrationParticipant {
    private final FileSystemAbstraction fileSystem;
    private boolean deleteObsoleteIndexes = false;
    private File labelIndexDirectory;
    private File schemaIndexDirectory;
    private final SchemaIndexProvider schemaIndexProvider;
    private final LabelScanStoreProvider labelScanStoreProvider;

    public SchemaIndexMigrator(FileSystemAbstraction fileSystem, SchemaIndexProvider schemaIndexProvider, LabelScanStoreProvider labelScanStoreProvider) {
        super("Indexes");
        this.fileSystem = fileSystem;
        this.schemaIndexProvider = schemaIndexProvider;
        this.labelScanStoreProvider = labelScanStoreProvider;
    }

    @Override
    public void migrate(File storeDir, File migrationDir, MigrationProgressMonitor.Section progressMonitor, String versionToMigrateFrom, String versionToMigrateTo) throws IOException {
        RecordFormats to;
        RecordFormats from = RecordFormatSelector.selectForVersion(versionToMigrateFrom);
        if (!from.hasSameCapabilities(to = RecordFormatSelector.selectForVersion(versionToMigrateTo), CapabilityType.INDEX)) {
            this.schemaIndexDirectory = this.schemaIndexProvider.getSchemaIndexStoreDirectory(storeDir);
            this.labelIndexDirectory = LabelScanStoreProvider.getStoreDirectory(storeDir);
            this.deleteObsoleteIndexes = true;
        }
    }

    @Override
    public void moveMigratedFiles(File migrationDir, File storeDir, String versionToUpgradeFrom, String versionToMigrateTo) throws IOException {
        if (this.deleteObsoleteIndexes) {
            this.deleteIndexes(this.schemaIndexDirectory);
            this.deleteIndexes(this.labelIndexDirectory);
        }
    }

    private void deleteIndexes(File indexRootDirectory) throws IOException {
        this.fileSystem.deleteRecursively(indexRootDirectory);
    }
}

